/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractConfigAwareAjaxSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.actions.AllRequest;
import com.openexchange.ajax.mail.actions.ClearRequest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.SendRequest;
import com.openexchange.ajax.mail.actions.SendResponse;
import com.openexchange.ajax.mail.contenttypes.MailContentType;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.folder.json.FolderField;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import java.io.IOException;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public abstract class AbstractMailTest
extends AbstractConfigAwareAjaxSession {
    protected static final String MAIL_TEXT_BODY = "Mail text.<br /><br />People have been asking for support for the IMAP IDLE command for quite<br />a few years and I think I've finally figured out how to provide such<br />support safely.  The difficulty isn't in executing the command, which<br />is quite straightforward, the difficulty is in deciding how to expose<br />it to applications, and inhandling the multithreading issues that<br />arise.<br /><br />After three attempts, I've got a version that seems to work.  It passes<br />all my tests, including a multithreading test I wrote just for this<br />purpose.  So now it's time for others to try it out as well.  Below is<br />my writeup on how to use the IDLE command.  You can find the test<br />version of JavaMail (essentially an early version of JavaMail 1.4.1)<br />in the java.net Maven repository (you want the 1.4.1ea version):<br /><br />https://maven-repository.dev.java.net/nonav/repository/javax.mail/<br /><br />Note that this version is built with JDK 1.5 and thus requires JDK 1.5.<br /><br />Oh,and here's the entire list of what's fixed in this version so far:<br /><br />4107594 IMAP implementation should use the IDLE extension if available<br />6423701 Problem with using OrTerm when the protocol is IMAP<br />6431207 SMTP is adding extra CRLF to message content<br />6447295 IMAPMessage fails to return Content-Language from bodystructure<br />6447799 encoded text not decoded even when mail.mime.decodetext.strict is false<br />6447801 MimeBodyPart.writeTo reencodes data unnecessarily<br />6456422 NullPointerException in smtptransport when sending MimeMessages<br />        with no encoding<br />6456444 MimeMessages created from stream are not correctly handled<br />        with allow8bitmime<br />&lt;no id&gt; fix performance bug in base64 encoder; now even faster!";
    protected static final String LARGE_MAIL_TEXT_BODY = "Mail text.<br /><br />People have been asking for support for the IMAP IDLE command for quite<br />a few years and I think I've finally figured out how to provide such<br />support safely.  The difficulty isn't in executing the command, which<br />is quite straightforward, the difficulty is in deciding how to expose<br />it to applications, and inhandling the multithreading issues that<br />arise.<br /><br />After three attempts, I've got a version that seems to work.  It passes<br />all my tests, including a multithreading test I wrote just for this<br />purpose.  So now it's time for others to try it out as well.  Below is<br />my writeup on how to use the IDLE command.  You can find the test<br />version of JavaMail (essentially an early version of JavaMail 1.4.1)<br />in the java.net Maven repository (you want the 1.4.1ea version):<br /><br />https://maven-repository.dev.java.net/nonav/repository/javax.mail/<br /><br />Note that this version is built with JDK 1.5 and thus requires JDK 1.5.<br /><br />Oh,and here's the entire list of what's fixed in this version so far:<br /><br />4107594 IMAP implementation should use the IDLE extension if available<br />6423701 Problem with using OrTerm when the protocol is IMAP<br />6431207 SMTP is adding extra CRLF to message content<br />6447295 IMAPMessage fails to return Content-Language from bodystructure<br />6447799 encoded text not decoded even when mail.mime.decodetext.strict is false<br />6447801 MimeBodyPart.writeTo reencodes data unnecessarily<br />6456422 NullPointerException in smtptransport when sending MimeMessages<br />        with no encoding<br />6456444 MimeMessages created from stream are not correctly handled<br />        with allow8bitmime<br />&lt;no id&gt; fix performance bug in base64 encoder; now even faster!<br />Mail text.<br /><br />People have been asking for support for the IMAP IDLE command for quite<br />a few years and I think I've finally figured out how to provide such<br />support safely.  The difficulty isn't in executing the command, which<br />is quite straightforward, the difficulty is in deciding how to expose<br />it to applications, and inhandling the multithreading issues that<br />arise.<br /><br />After three attempts, I've got a version that seems to work.  It passes<br />all my tests, including a multithreading test I wrote just for this<br />purpose.  So now it's time for others to try it out as well.  Below is<br />my writeup on how to use the IDLE command.  You can find the test<br />version of JavaMail (essentially an early version of JavaMail 1.4.1)<br />in the java.net Maven repository (you want the 1.4.1ea version):<br /><br />https://maven-repository.dev.java.net/nonav/repository/javax.mail/<br /><br />Note that this version is built with JDK 1.5 and thus requires JDK 1.5.<br /><br />Oh,and here's the entire list of what's fixed in this version so far:<br /><br />4107594 IMAP implementation should use the IDLE extension if available<br />6423701 Problem with using OrTerm when the protocol is IMAP<br />6431207 SMTP is adding extra CRLF to message content<br />6447295 IMAPMessage fails to return Content-Language from bodystructure<br />6447799 encoded text not decoded even when mail.mime.decodetext.strict is false<br />6447801 MimeBodyPart.writeTo reencodes data unnecessarily<br />6456422 NullPointerException in smtptransport when sending MimeMessages<br />        with no encoding<br />6456444 MimeMessages created from stream are not correctly handled<br />        with allow8bitmime<br />&lt;no id&gt; fix performance bug in base64 encoder; now even faster!<br />Mail text.<br /><br />People have been asking for support for the IMAP IDLE command for quite<br />a few years and I think I've finally figured out how to provide such<br />support safely.  The difficulty isn't in executing the command, which<br />is quite straightforward, the difficulty is in deciding how to expose<br />it to applications, and inhandling the multithreading issues that<br />arise.<br /><br />After three attempts, I've got a version that seems to work.  It passes<br />all my tests, including a multithreading test I wrote just for this<br />purpose.  So now it's time for others to try it out as well.  Below is<br />my writeup on how to use the IDLE command.  You can find the test<br />version of JavaMail (essentially an early version of JavaMail 1.4.1)<br />in the java.net Maven repository (you want the 1.4.1ea version):<br /><br />https://maven-repository.dev.java.net/nonav/repository/javax.mail/<br /><br />Note that this version is built with JDK 1.5 and thus requires JDK 1.5.<br /><br />Oh,and here's the entire list of what's fixed in this version so far:<br /><br />4107594 IMAP implementation should use the IDLE extension if available<br />6423701 Problem with using OrTerm when the protocol is IMAP<br />6431207 SMTP is adding extra CRLF to message content<br />6447295 IMAPMessage fails to return Content-Language from bodystructure<br />6447799 encoded text not decoded even when mail.mime.decodetext.strict is false<br />6447801 MimeBodyPart.writeTo reencodes data unnecessarily<br />6456422 NullPointerException in smtptransport when sending MimeMessages<br />        with no encoding<br />6456444 MimeMessages created from stream are not correctly handled<br />        with allow8bitmime<br />&lt;no id&gt; fix performance bug in base64 encoder; now even faster!<br />Mail text.<br /><br />People have been asking for support for the IMAP IDLE command for quite<br />a few years and I think I've finally figured out how to provide such<br />support safely.  The difficulty isn't in executing the command, which<br />is quite straightforward, the difficulty is in deciding how to expose<br />it to applications, and inhandling the multithreading issues that<br />arise.<br /><br />After three attempts, I've got a version that seems to work.  It passes<br />all my tests, including a multithreading test I wrote just for this<br />purpose.  So now it's time for others to try it out as well.  Below is<br />my writeup on how to use the IDLE command.  You can find the test<br />version of JavaMail (essentially an early version of JavaMail 1.4.1)<br />in the java.net Maven repository (you want the 1.4.1ea version):<br /><br />https://maven-repository.dev.java.net/nonav/repository/javax.mail/<br /><br />Note that this version is built with JDK 1.5 and thus requires JDK 1.5.<br /><br />Oh,and here's the entire list of what's fixed in this version so far:<br /><br />4107594 IMAP implementation should use the IDLE extension if available<br />6423701 Problem with using OrTerm when the protocol is IMAP<br />6431207 SMTP is adding extra CRLF to message content<br />6447295 IMAPMessage fails to return Content-Language from bodystructure<br />6447799 encoded text not decoded even when mail.mime.decodetext.strict is false<br />6447801 MimeBodyPart.writeTo reencodes data unnecessarily<br />6456422 NullPointerException in smtptransport when sending MimeMessages<br />        with no encoding<br />6456444 MimeMessages created from stream are not correctly handled<br />        with allow8bitmime<br />&lt;no id&gt; fix performance bug in base64 encoder; now even faster!<br />Mail text.<br /><br />People have been asking for support for the IMAP IDLE command for quite<br />a few years and I think I've finally figured out how to provide such<br />support safely.  The difficulty isn't in executing the command, which<br />is quite straightforward, the difficulty is in deciding how to expose<br />it to applications, and inhandling the multithreading issues that<br />arise.<br /><br />After three attempts, I've got a version that seems to work.  It passes<br />all my tests, including a multithreading test I wrote just for this<br />purpose.  So now it's time for others to try it out as well.  Below is<br />my writeup on how to use the IDLE command.  You can find the test<br />version of JavaMail (essentially an early version of JavaMail 1.4.1)<br />in the java.net Maven repository (you want the 1.4.1ea version):<br /><br />https://maven-repository.dev.java.net/nonav/repository/javax.mail/<br /><br />Note that this version is built with JDK 1.5 and thus requires JDK 1.5.<br /><br />Oh,and here's the entire list of what's fixed in this version so far:<br /><br />4107594 IMAP implementation should use the IDLE extension if available<br />6423701 Problem with using OrTerm when the protocol is IMAP<br />6431207 SMTP is adding extra CRLF to message content<br />6447295 IMAPMessage fails to return Content-Language from bodystructure<br />6447799 encoded text not decoded even when mail.mime.decodetext.strict is false<br />6447801 MimeBodyPart.writeTo reencodes data unnecessarily<br />6456422 NullPointerException in smtptransport when sending MimeMessages<br />        with no encoding<br />6456444 MimeMessages created from stream are not correctly handled<br />        with allow8bitmime<br />&lt;no id&gt; fix performance bug in base64 encoder; now even faster!<br />Mail text.<br /><br />People have been asking for support for the IMAP IDLE command for quite<br />a few years and I think I've finally figured out how to provide such<br />support safely.  The difficulty isn't in executing the command, which<br />is quite straightforward, the difficulty is in deciding how to expose<br />it to applications, and inhandling the multithreading issues that<br />arise.<br /><br />After three attempts, I've got a version that seems to work.  It passes<br />all my tests, including a multithreading test I wrote just for this<br />purpose.  So now it's time for others to try it out as well.  Below is<br />my writeup on how to use the IDLE command.  You can find the test<br />version of JavaMail (essentially an early version of JavaMail 1.4.1)<br />in the java.net Maven repository (you want the 1.4.1ea version):<br /><br />https://maven-repository.dev.java.net/nonav/repository/javax.mail/<br /><br />Note that this version is built with JDK 1.5 and thus requires JDK 1.5.<br /><br />Oh,and here's the entire list of what's fixed in this version so far:<br /><br />4107594 IMAP implementation should use the IDLE extension if available<br />6423701 Problem with using OrTerm when the protocol is IMAP<br />6431207 SMTP is adding extra CRLF to message content<br />6447295 IMAPMessage fails to return Content-Language from bodystructure<br />6447799 encoded text not decoded even when mail.mime.decodetext.strict is false<br />6447801 MimeBodyPart.writeTo reencodes data unnecessarily<br />6456422 NullPointerException in smtptransport when sending MimeMessages<br />        with no encoding<br />6456444 MimeMessages created from stream are not correctly handled<br />        with allow8bitmime<br />&lt;no id&gt; fix performance bug in base64 encoder; now even faster!<br />Mail text.<br /><br />People have been asking for support for the IMAP IDLE command for quite<br />a few years and I think I've finally figured out how to provide such<br />support safely.  The difficulty isn't in executing the command, which<br />is quite straightforward, the difficulty is in deciding how to expose<br />it to applications, and inhandling the multithreading issues that<br />arise.<br /><br />After three attempts, I've got a version that seems to work.  It passes<br />all my tests, including a multithreading test I wrote just for this<br />purpose.  So now it's time for others to try it out as well.  Below is<br />my writeup on how to use the IDLE command.  You can find the test<br />version of JavaMail (essentially an early version of JavaMail 1.4.1)<br />in the java.net Maven repository (you want the 1.4.1ea version):<br /><br />https://maven-repository.dev.java.net/nonav/repository/javax.mail/<br /><br />Note that this version is built with JDK 1.5 and thus requires JDK 1.5.<br /><br />Oh,and here's the entire list of what's fixed in this version so far:<br /><br />4107594 IMAP implementation should use the IDLE extension if available<br />6423701 Problem with using OrTerm when the protocol is IMAP<br />6431207 SMTP is adding extra CRLF to message content<br />6447295 IMAPMessage fails to return Content-Language from bodystructure<br />6447799 encoded text not decoded even when mail.mime.decodetext.strict is false<br />6447801 MimeBodyPart.writeTo reencodes data unnecessarily<br />6456422 NullPointerException in smtptransport when sending MimeMessages<br />        with no encoding<br />6456444 MimeMessages created from stream are not correctly handled<br />        with allow8bitmime<br />&lt;no id&gt; fix performance bug in base64 encoder; now even faster!<br />";
    public static final String MAIL_SUBJECT = "The mail subject";
    public static final int[] COLUMNS_DEFAULT_LIST = new int[]{600, 601, 612, 602, 603, 607, 610, 608, 611, 614, 102, 604, 609};
    protected static final int[] COLUMNS_FOLDER_ID = new int[]{MailListField.FOLDER_ID.getField(), MailListField.ID.getField()};

    protected AbstractMailTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected int count(String folder) throws OXException, IOException, JSONException {
        JSONObject data = (JSONObject)this.client.execute(new com.openexchange.ajax.folder.actions.GetRequest((API)EnumAPI.OX_NEW, folder, new int[]{FolderField.TOTAL.getColumn()})).getData();
        return data.getInt(FolderField.TOTAL.getName());
    }

    protected static final String[][] toFolderAndIDs(Object[][] array) {
        String[][] retval = new String[array.length][];
        for (int i = 0; i < retval.length; ++i) {
            if (array[i] == null || array[i].length != 2) {
                return null;
            }
            retval[i] = new String[array[i].length];
            retval[i][0] = array[i][0] == null ? null : array[i][0].toString();
            retval[i][1] = array[i][1] == null ? null : array[i][1].toString();
        }
        return retval;
    }

    protected final JSONObject createSelfAddressed25KBMailObject(String subject) throws OXException, JSONException, IOException, SAXException {
        return this.createEMail(this.getSendAddress(), subject, MailContentType.ALTERNATIVE.toString(), LARGE_MAIL_TEXT_BODY);
    }

    protected JSONObject createEMail(String recipient, String subject, String content_type, String text) throws OXException, JSONException, IOException {
        return AbstractMailTest.createEMail(this.getClient(), recipient, subject, content_type, text);
    }

    protected static JSONObject createEMail(AJAXClient client, String recipient, String subject, String content_type, String text) throws OXException, JSONException, IOException {
        JSONObject myMail = new JSONObject();
        myMail.put(MailJSONField.FROM.getKey(), (Object)AbstractMailTest.getSendAddress(client));
        myMail.put(MailJSONField.RECIPIENT_TO.getKey(), (Object)recipient);
        myMail.put(MailJSONField.RECIPIENT_CC.getKey(), (Object)"");
        myMail.put(MailJSONField.RECIPIENT_BCC.getKey(), (Object)"");
        myMail.put(MailJSONField.SUBJECT.getKey(), (Object)subject);
        myMail.put(MailJSONField.PRIORITY.getKey(), (Object)"3");
        JSONObject mailBody = new JSONObject();
        mailBody.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)content_type);
        mailBody.put(MailJSONField.CONTENT.getKey(), (Object)text);
        JSONArray attachments = new JSONArray();
        attachments.put((Object)mailBody);
        myMail.put(MailJSONField.ATTACHMENTS.getKey(), (Object)attachments);
        return myMail;
    }

    protected final JSONObject createSelfAddressed25KBMailObject() throws OXException, JSONException, IOException, SAXException {
        return this.createSelfAddressed25KBMailObject(MAIL_SUBJECT);
    }

    protected static final boolean isSP3() {
        return Boolean.parseBoolean(AJAXConfig.getProperty(AJAXConfig.Property.IS_SP3));
    }

    protected final void clearFolder(String folder) throws OXException, IOException, SAXException, JSONException {
        Executor.execute(this.getSession(), new ClearRequest(folder).setHardDelete(true));
    }

    protected final String[][] getFolderAndIDs(String folder) throws OXException, IOException, SAXException, JSONException {
        CommonAllResponse allR = Executor.execute(this.getSession(), new AllRequest(folder, COLUMNS_FOLDER_ID, 0, null, true));
        Object[][] array = allR.getArray();
        String[][] folderAndIDs = new String[array.length][];
        for (int i = 0; i < array.length; ++i) {
            folderAndIDs[i] = new String[]{array[i][0].toString(), array[i][1].toString()};
        }
        return folderAndIDs;
    }

    protected String getInboxFolder() throws OXException, IOException, SAXException, JSONException {
        return this.getClient().getValues().getInboxFolder();
    }

    protected String getSentFolder() throws OXException, IOException, SAXException, JSONException {
        return this.getClient().getValues().getSentFolder();
    }

    protected String getTrashFolder() throws OXException, IOException, SAXException, JSONException {
        return this.getClient().getValues().getTrashFolder();
    }

    protected String getDraftsFolder() throws OXException, IOException, SAXException, JSONException {
        return this.getClient().getValues().getDraftsFolder();
    }

    protected String getSendAddress() throws OXException, IOException, JSONException {
        return AbstractMailTest.getSendAddress(this.getClient());
    }

    protected static String getSendAddress(AJAXClient client) throws OXException, IOException, JSONException {
        return client.getValues().getSendAddress();
    }

    protected int getPrivateFolder() throws OXException, IOException, SAXException, JSONException {
        return this.getClient().getValues().getPrivateTaskFolder();
    }

    protected TimeZone getTimeZone() throws OXException, IOException, SAXException, JSONException {
        return this.getClient().getValues().getTimeZone();
    }

    protected String[] sendMail(String mail) throws OXException, IOException, JSONException {
        return AbstractMailTest.sendMail(this.client, mail);
    }

    protected static String[] sendMail(AJAXClient client, String mail) throws OXException, IOException, JSONException {
        SendResponse response = client.execute(new SendRequest(mail));
        return response.getFolderAndID();
    }

    protected String generateMail() throws Exception {
        JSONObject mailObject = this.createSelfAddressed25KBMailObject();
        return mailObject.toString();
    }

    protected String generateMail(String subject) throws Exception {
        JSONObject mailObject = this.createSelfAddressed25KBMailObject(subject);
        return mailObject.toString();
    }

    protected JSONObject getFirstMailInFolder(String inboxFolder) throws OXException, IOException, SAXException, JSONException {
        CommonAllResponse response = this.getClient().execute(new AllRequest(inboxFolder, new int[]{600}, -1, null, true));
        JSONArray arr = (JSONArray)response.getData();
        JSONArray mailFields = arr.getJSONArray(0);
        String id = mailFields.getString(0);
        GetResponse response2 = this.getClient().execute(new GetRequest(inboxFolder, id));
        return (JSONObject)response2.getData();
    }

    public TestMail getMail(String folder, String id) throws OXException, IOException, SAXException, JSONException {
        GetRequest getRequest = new GetRequest(folder, id);
        GetResponse getResponse = this.getClient().execute(getRequest);
        JSONObject jsonMail = (JSONObject)getResponse.getData();
        return new TestMail(jsonMail);
    }
}

