/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.test;

import com.openexchange.ajax.infostore.actions.DeleteInfostoreRequest;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.GetInfostoreResponse;
import com.openexchange.ajax.infostore.actions.NewInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreResponse;
import com.openexchange.ajax.infostore.test.AbstractInfostoreTest;
import com.openexchange.configuration.MailConfig;
import com.openexchange.file.storage.DefaultFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TryAddVersionTest
extends AbstractInfostoreTest {
    private List<String> ids;
    private final String[] COLUMNS = new String[]{"700", "702", "710", "711"};
    private final String filename = "bug.eml";

    public TryAddVersionTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ids = new ArrayList<String>(2);
        DefaultFile file = new DefaultFile();
        file.setFolderId(String.valueOf(this.client.getValues().getPrivateInfostoreFolder()));
        file.setFileName("tryAddVersion");
        File f = new File(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR) + "bug.eml");
        NewInfostoreRequest req = new NewInfostoreRequest((com.openexchange.file.storage.File)file, f);
        NewInfostoreResponse resp = this.client.execute(req);
        this.ids.add(resp.getID());
    }

    @Override
    public void tearDown() throws Exception {
        if (this.ids != null) {
            for (String id : this.ids) {
                DeleteInfostoreRequest req = new DeleteInfostoreRequest(id, String.valueOf(this.client.getValues().getPrivateInfostoreFolder()), new Date());
                req.setHardDelete(true);
                this.client.execute(req);
            }
        }
        this.ids = null;
        super.tearDown();
    }

    public void testAddVersion() throws Exception {
        DefaultFile file = new DefaultFile();
        file.setFolderId(String.valueOf(this.client.getValues().getPrivateInfostoreFolder()));
        file.setFileName("tryAddVersion");
        File f = new File(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR) + "bug.eml");
        NewInfostoreRequest req = new NewInfostoreRequest((com.openexchange.file.storage.File)file, f, true);
        NewInfostoreResponse resp = this.client.execute(req);
        TryAddVersionTest.assertFalse((boolean)resp.hasError());
        this.ids.add(resp.getID());
        GetInfostoreRequest getReq = new GetInfostoreRequest(resp.getID(), this.COLUMNS);
        GetInfostoreResponse getResp = this.client.execute(getReq);
        TryAddVersionTest.assertNotNull((Object)((Object)getResp));
        com.openexchange.file.storage.File uploaded = getResp.getDocumentMetadata();
        TryAddVersionTest.assertEquals((int)2, (int)uploaded.getNumberOfVersions());
    }

    public void testFallback() throws Exception {
        DefaultFile file = new DefaultFile();
        file.setFolderId(String.valueOf(this.client.getValues().getPrivateInfostoreFolder()));
        file.setFileName("tryAddVersion");
        File f = new File(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR) + "bug.eml");
        NewInfostoreRequest req = new NewInfostoreRequest((com.openexchange.file.storage.File)file, f, false);
        NewInfostoreResponse resp = this.client.execute(req);
        TryAddVersionTest.assertFalse((boolean)resp.hasError());
        this.ids.add(resp.getID());
        GetInfostoreRequest getReq = new GetInfostoreRequest(resp.getID(), this.COLUMNS);
        GetInfostoreResponse getResp = this.client.execute(getReq);
        TryAddVersionTest.assertNotNull((Object)((Object)getResp));
        com.openexchange.file.storage.File uploaded = getResp.getDocumentMetadata();
        TryAddVersionTest.assertFalse((boolean)"tryAddVersion".equals(uploaded.getFileName()));
        TryAddVersionTest.assertTrue((boolean)uploaded.getFileName().endsWith("(1)"));
        this.ids.add(uploaded.getId());
    }
}

