/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.test;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreRequest;
import com.openexchange.ajax.infostore.actions.GetDocumentRequest;
import com.openexchange.ajax.infostore.actions.GetDocumentResponse;
import com.openexchange.ajax.infostore.actions.NewInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreResponse;
import com.openexchange.ajax.infostore.test.AbstractInfostoreTest;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.test.TestInit;
import java.io.File;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class Bug44622Test
extends AbstractInfostoreTest {
    private String fileID;

    public Bug44622Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        DefaultFile file = new DefaultFile();
        file.setFileName("Bug 44622 Test");
        file.setFolderId(String.valueOf(this.client.getValues().getPrivateInfostoreFolder()));
        NewInfostoreRequest req = new NewInfostoreRequest((com.openexchange.file.storage.File)file, upload);
        NewInfostoreResponse resp = this.client.execute(req);
        this.fileID = resp.getID();
    }

    @Override
    public void tearDown() throws Exception {
        DeleteInfostoreRequest req = new DeleteInfostoreRequest(this.fileID, String.valueOf(this.client.getValues().getPrivateInfostoreFolder()), new Date());
        this.client.execute(req);
        super.tearDown();
    }

    public void testBug44622() throws Exception {
        Header[] headers;
        GetDocumentRequest req = new GetDocumentRequest(String.valueOf(this.client.getValues().getPrivateInfostoreFolder()), this.fileID);
        req.setAdditionalParameters(new AJAXRequest.Parameter("content_disposition", ""));
        GetDocumentResponse resp = this.client.execute(req);
        Bug44622Test.assertFalse((boolean)resp.hasError());
        HttpResponse httpResp = resp.getHttpResponse();
        for (Header header : headers = httpResp.getHeaders("Content-Disposition")) {
            Bug44622Test.assertNotNull((Object)header.getValue());
            Bug44622Test.assertTrue((boolean)header.getValue().contains("attachment;"));
        }
    }
}

