/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.test;

import com.openexchange.ajax.infostore.test.AbstractInfostoreTest;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.groupware.container.FolderObject;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class AnotherCreateAndDeleteInfostoreTest
extends AbstractInfostoreTest {
    public AnotherCreateAndDeleteInfostoreTest(String name) {
        super(name);
    }

    public void testCreatingOneItem() throws OXException, IOException, SAXException, JSONException, OXException {
        FolderObject folder = this.generateInfostoreFolder("InfostoreCreateDeleteTest" + System.currentTimeMillis());
        this.fMgr.insertFolderOnServer(folder);
        DefaultFile expected = new DefaultFile();
        expected.setCreated(new Date());
        expected.setFolderId(String.valueOf(folder.getObjectID()));
        expected.setTitle("InfostoreCreateDeleteTest Item");
        expected.setLastModified(new Date());
        LinkedHashMap<String, Object> meta = new LinkedHashMap<String, Object>(2);
        meta.put("customField0012", "value0012");
        meta.put("customField0013", 2);
        expected.setMeta(meta);
        this.infoMgr.newAction((File)expected);
        AnotherCreateAndDeleteInfostoreTest.assertFalse((String)"Creating an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        File actual = this.infoMgr.getAction(expected.getId());
        AnotherCreateAndDeleteInfostoreTest.assertEquals((String)"Name should be the same", (String)expected.getTitle(), (String)actual.getTitle());
        Map actualMeta = actual.getMeta();
        AnotherCreateAndDeleteInfostoreTest.assertTrue((String)"Meta not available, but should", (actualMeta != meta && !actualMeta.isEmpty() ? 1 : 0) != 0);
        Object actualValue = actualMeta.get("customField0012");
        AnotherCreateAndDeleteInfostoreTest.assertNotNull((String)"Unexpected meta value", actualValue);
        AnotherCreateAndDeleteInfostoreTest.assertEquals((String)"Unexpected meta value", (String)"value0012", (String)actualValue.toString());
        actualValue = actualMeta.get("customField0013");
        AnotherCreateAndDeleteInfostoreTest.assertNotNull((String)"Unexpected meta value", actualValue);
        AnotherCreateAndDeleteInfostoreTest.assertEquals((String)"Unexpected meta value", (String)"2", (String)actualValue.toString());
        this.infoMgr.deleteAction((File)expected);
        AnotherCreateAndDeleteInfostoreTest.assertFalse((String)"Deleting an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
    }
}

