/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.eas;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.folder.actions.SubscribeRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.Date;
import java.util.LinkedList;

public class MultipleSubscribeWithoutParentTest
extends AbstractAJAXSession {
    private AJAXClient client;

    public MultipleSubscribeWithoutParentTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    private String createPrivateCalendarFolder(String prefix, int parentId) throws Throwable {
        FolderObject fo = new FolderObject();
        fo.setParentFolderID(parentId > 0 ? parentId : 1);
        fo.setFolderName((null == prefix ? "testCalendarFolder" : prefix) + System.currentTimeMillis());
        fo.setModule(2);
        OCLPermission oclP = new OCLPermission();
        oclP.setEntity(this.client.getValues().getUserId());
        oclP.setGroupPermission(false);
        oclP.setFolderAdmin(true);
        oclP.setAllPermission(128, 128, 128, 128);
        fo.setPermissionsAsArray(new OCLPermission[]{oclP});
        InsertRequest request = new InsertRequest((API)EnumAPI.OUTLOOK, fo);
        InsertResponse response = this.client.execute(request);
        return (String)response.getResponse().getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubscribeMultiplePrivate() throws Throwable {
        String parent = FolderStorage.ROOT_ID;
        LinkedList<String> ids = new LinkedList<String>();
        try {
            String newId = this.createPrivateCalendarFolder("testCalendarParentFolder", -1);
            MultipleSubscribeWithoutParentTest.assertNotNull((String)"New ID must not be null!", (Object)newId);
            ids.addFirst(newId);
            String newSubId = this.createPrivateCalendarFolder("testCalendarChildFolder", Integer.parseInt(newId));
            MultipleSubscribeWithoutParentTest.assertNotNull((String)"New ID must not be null!", (Object)newSubId);
            ids.addFirst(newSubId);
            SubscribeRequest subscribeRequest = new SubscribeRequest(EnumAPI.EAS_FOLDERS, newId, true);
            subscribeRequest.addFolderId(newSubId, true);
            this.client.execute(subscribeRequest);
            ListRequest listRequest = new ListRequest((API)EnumAPI.EAS_FOLDERS, newId);
            ListResponse listResponse = this.client.execute(listRequest);
            boolean found = false;
            for (Object[] vals : listResponse.getArray()) {
                if (!newSubId.equals(vals[0].toString())) continue;
                found = true;
                break;
            }
            MultipleSubscribeWithoutParentTest.assertTrue((String)"Subscribed subfolder not found.", (boolean)found);
            listRequest = new ListRequest((API)EnumAPI.EAS_FOLDERS, parent);
            listResponse = this.client.execute(listRequest);
            found = false;
            for (Object[] vals : listResponse.getArray()) {
                if (!newId.equals(vals[0].toString())) continue;
                found = true;
                break;
            }
            MultipleSubscribeWithoutParentTest.assertTrue((String)"Subscribed folder not found.", (boolean)found);
            subscribeRequest = new SubscribeRequest(EnumAPI.EAS_FOLDERS, newId, true);
            subscribeRequest.addFolderId(newSubId, false);
            this.client.execute(subscribeRequest);
            listRequest = new ListRequest((API)EnumAPI.EAS_FOLDERS, newId);
            listResponse = this.client.execute(listRequest);
            found = false;
            for (Object[] vals : listResponse.getArray()) {
                if (!newSubId.equals(vals[0].toString())) continue;
                found = true;
                break;
            }
            MultipleSubscribeWithoutParentTest.assertFalse((String)"Unsubscribed subfolder still available.", (boolean)found);
        }
        finally {
            int size = ids.size();
            for (int i = 0; i < size; ++i) {
                String id = (String)ids.get(i);
                SubscribeRequest subscribeRequest = new SubscribeRequest(EnumAPI.EAS_FOLDERS, parent, true);
                subscribeRequest.addFolderId(id, false);
                this.client.execute(subscribeRequest);
                try {
                    DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, id, new Date());
                    this.client.execute(deleteRequest);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

