/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Autoboxing;
import com.openexchange.test.PermissionTools;
import java.util.Date;
import java.util.Iterator;

public class Bug16303Test
extends AbstractAJAXSession {
    private AJAXClient clientA;
    private AJAXClient clientB;
    private FolderObject createdFolder;

    public Bug16303Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.clientA = this.getClient();
        this.clientB = new AJAXClient(AJAXClient.User.User2);
        this.createdFolder = new FolderObject();
        this.createdFolder.setModule(2);
        this.createdFolder.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.createdFolder.setPermissions(PermissionTools.P(Autoboxing.I((int)this.clientA.getValues().getUserId()), "arawada/a", Autoboxing.I((int)this.clientB.getValues().getUserId()), "arawada"));
        this.createdFolder.setFolderName("testFolder4Bug16303");
        InsertRequest iReq = new InsertRequest((API)EnumAPI.OUTLOOK, this.createdFolder);
        InsertResponse iResp = this.client.execute(iReq);
        iResp.fillObject((DataObject)this.createdFolder);
        this.createdFolder.setLastModified(new Date());
        ListRequest listRequest = new ListRequest((API)EnumAPI.OUTLOOK, FolderStorage.SHARED_ID);
        ListResponse listResponse = this.clientB.execute(listRequest);
        String expectedId = "u:" + this.clientA.getValues().getUserId();
        Iterator<FolderObject> iter = listResponse.getFolder();
        FolderObject foundUserShared = null;
        while (iter.hasNext()) {
            FolderObject folder = iter.next();
            if (!expectedId.equals(folder.getFullName())) continue;
            foundUserShared = folder;
        }
        Bug16303Test.assertNotNull((String)"Expected user named shared folder below root shared folder.", foundUserShared);
        ListRequest listRequest2 = new ListRequest((API)EnumAPI.OUTLOOK, foundUserShared.getFullName());
        listResponse = this.clientB.execute(listRequest2);
        iter = listResponse.getFolder();
        FolderObject foundShared = null;
        while (iter.hasNext()) {
            FolderObject folder = iter.next();
            if (folder.getObjectID() != folder.getObjectID()) continue;
            foundShared = folder;
        }
        Bug16303Test.assertNotNull((String)"Shared folder expected below shared parent folder.", foundShared);
    }

    @Override
    protected void tearDown() throws Exception {
        this.clientA.execute(new DeleteRequest((API)EnumAPI.OUTLOOK, this.createdFolder));
        super.tearDown();
    }

    public void testForDisappearingFolder() throws Throwable {
        GetRequest request = new GetRequest((API)EnumAPI.OUTLOOK, this.clientA.getValues().getPrivateAppointmentFolder());
        GetResponse response = this.clientA.execute(request);
        FolderObject testFolder = response.getFolder();
        Bug16303Test.assertTrue((String)"Private appointment folder must have subfolder flag true.", (boolean)testFolder.hasSubfolders());
    }
}

