/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.folder.actions.VersionsResponse;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.AbstractFileFieldHandler;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileFieldHandler;
import com.openexchange.file.storage.FileFieldSwitcher;
import com.openexchange.file.storage.json.FileMetadataFieldParser;
import com.openexchange.file.storage.json.JsonFieldHandler;
import com.openexchange.file.storage.meta.FileFieldSet;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;

public class VersionsParser
extends AbstractAJAXParser<VersionsResponse> {
    private static final String DATA = "data";
    private final int[] columns;

    protected VersionsParser(boolean failOnError, int[] columns) {
        super(failOnError);
        Arrays.sort(columns);
        this.columns = columns;
    }

    @Override
    protected VersionsResponse createResponse(Response response) throws JSONException {
        FileFieldSet fileFieldSet = new FileFieldSet();
        VersionsResponse versionsResponse = new VersionsResponse(response);
        JSONObject json = ResponseWriter.getJSON((Response)response);
        if (json.has(DATA)) {
            JSONArray versions = (JSONArray)json.get(DATA);
            for (int i = 0; i < versions.length(); ++i) {
                DefaultFile metadata = new DefaultFile();
                int columncount = 0;
                for (int column : this.columns) {
                    File.Field field = File.Field.get((int)column);
                    if (null == field) continue;
                    Object orig = ((JSONArray)versions.get(i)).get(columncount);
                    try {
                        Object converted = FileMetadataFieldParser.convert((File.Field)field, (Object)orig);
                        field.doSwitch((FileFieldSwitcher)fileFieldSet, new Object[]{metadata, converted});
                    }
                    catch (OXException e) {
                        e.printStackTrace();
                    }
                    ++columncount;
                }
                versionsResponse.addVersion((File)metadata);
            }
        }
        return versionsResponse;
    }

    private static FileFieldHandler getJsonHandler(final File file, final JsonFieldHandler fieldHandler) {
        return new AbstractFileFieldHandler(){

            public Object handle(File.Field field, Object ... args) {
                JSONObject jsonObject = (JSONObject)this.get(0, JSONObject.class, args);
                try {
                    jsonObject.put(field.getName(), fieldHandler.handle(field, new Object[]{file}));
                }
                catch (JSONException e) {
                    LoggerFactory.getLogger(VersionsParser.class);
                }
                return jsonObject;
            }
        };
    }
}

