/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.xml.sax.SAXException;

public final class FolderTools {
    private FolderTools() {
    }

    @Deprecated
    public static ListResponse list(AJAXClient client, ListRequest request) throws OXException, IOException, SAXException, JSONException {
        return Executor.execute(client, request);
    }

    public static List<FolderObject> getSubFolders(AJAXClient client, String parent, boolean ignoreMailFolder) throws OXException, IOException, SAXException, JSONException, OXException {
        ListRequest request = new ListRequest((API)EnumAPI.OX_OLD, parent, ignoreMailFolder);
        ListResponse response = client.execute(request);
        ArrayList<FolderObject> retval = new ArrayList<FolderObject>();
        Iterator<FolderObject> iter = response.getFolder();
        while (iter.hasNext()) {
            retval.add(iter.next());
        }
        return retval;
    }

    public static List<FolderObject> convert(Iterator<FolderObject> iter) {
        ArrayList<FolderObject> retval = new ArrayList<FolderObject>();
        while (iter.hasNext()) {
            retval.add(iter.next());
        }
        return retval;
    }

    public static void shareFolder(AJAXClient client, API api, int folderId, int userId, int fp, int opr, int opw, int opd) throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        GetRequest getQ = new GetRequest(api, folderId);
        GetResponse getR = client.execute(getQ);
        FolderObject origFolder = getR.getFolder();
        FolderObject changed = new FolderObject();
        changed.setObjectID(folderId);
        changed.setLastModified(getR.getTimestamp());
        ArrayList<OCLPermission> permissions = new ArrayList<OCLPermission>();
        for (OCLPermission permission : origFolder.getPermissions()) {
            if (permission.getEntity() == userId) continue;
            permissions.add(permission);
        }
        OCLPermission addedPerm = new OCLPermission();
        addedPerm.setEntity(userId);
        addedPerm.setAllPermission(fp, opr, opw, opd);
        permissions.add(addedPerm);
        changed.setPermissions(permissions);
        UpdateRequest updQ = new UpdateRequest(api, changed);
        client.execute(updQ);
    }

    public static void unshareFolder(AJAXClient client, API api, int folderId, int userId) throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        GetRequest getQ = new GetRequest(api, folderId);
        GetResponse getR = client.execute(getQ);
        FolderObject origFolder = getR.getFolder();
        ArrayList permissions = new ArrayList();
        permissions.addAll(origFolder.getPermissions());
        Iterator iter = permissions.iterator();
        while (iter.hasNext()) {
            if (((OCLPermission)iter.next()).getEntity() != userId) continue;
            iter.remove();
        }
        FolderObject changed = new FolderObject();
        changed.setObjectID(folderId);
        changed.setLastModified(getR.getTimestamp());
        changed.setPermissions(permissions);
        UpdateRequest updQ = new UpdateRequest(api, changed);
        client.execute(updQ);
    }
}

