/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.Header;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.Filter;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractFindRequest<T extends AbstractAJAXResponse>
implements AJAXRequest<T> {
    public static final String FIND_URL = "/ajax/find";
    private final Map<String, String> options;

    protected AbstractFindRequest(Map<String, String> options) {
        this.options = options;
    }

    @Override
    public String getServletPath() {
        return FIND_URL;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    protected void addOptions(JSONObject jBody) throws JSONException {
        if (this.options != null) {
            JSONObject jOptions = new JSONObject();
            for (Map.Entry<String, String> entry : this.options.entrySet()) {
                jOptions.put(entry.getKey(), (Object)entry.getValue());
            }
            jBody.put("options", (Object)jOptions);
        }
    }

    protected void addFacets(JSONObject jBody, List<ActiveFacet> activeFacets) throws JSONException {
        if (activeFacets != null) {
            JSONArray jFacets = new JSONArray();
            for (ActiveFacet facet : activeFacets) {
                JSONObject jFacet = new JSONObject();
                jFacet.put("facet", (Object)facet.getType().getId());
                jFacet.put("value", (Object)facet.getValueId());
                Filter filter = facet.getFilter();
                if (filter != null && filter != Filter.NO_FILTER) {
                    JSONObject jFilter = new JSONObject(3);
                    List filterQueries = filter.getQueries();
                    JSONArray jQueries = new JSONArray(filterQueries.size());
                    for (String sQuery : filterQueries) {
                        jQueries.put((Object)sQuery);
                    }
                    jFilter.put("queries", (Object)jQueries);
                    List fields = filter.getFields();
                    JSONArray jFields = new JSONArray(fields.size());
                    for (String sField : fields) {
                        jFields.put((Object)sField);
                    }
                    jFilter.put("fields", (Object)jFields);
                    jFacet.put("filter", (Object)jFilter);
                }
                jFacets.put((Object)jFacet);
            }
            jBody.put("facets", (Object)jFacets);
        }
    }
}

