/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.config;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.GetResponse;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.SetResponse;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TimeZone;
import org.json.JSONException;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class ConfigTools
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigTools.class);
    private static final String CONFIG_URL = "/ajax/config/";

    private ConfigTools() {
    }

    public static String readSetting(WebConversation conversation, String hostName, String sessionId, String path) throws IOException, SAXException, JSONException {
        LOG.trace("Reading setting.");
        GetMethodWebRequest req = new GetMethodWebRequest("http://" + hostName + CONFIG_URL + '/' + path);
        req.setParameter("session", sessionId);
        WebResponse resp = conversation.getResponse((WebRequest)req);
        ConfigTools.assertEquals((String)"Response code is not okay.", (long)200L, (long)resp.getResponseCode());
        String body = resp.getText();
        LOG.trace("Response body: \"" + body + "\"");
        Response response = Response.parse((String)body);
        ConfigTools.assertFalse((String)response.getErrorMessage(), (boolean)response.hasError());
        return response.getData().toString();
    }

    public static void storeSetting(WebConversation conversation, String hostName, String sessionId, String path, String value) throws Throwable {
        LOG.trace("Storing setting.");
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", sessionId);
        PutMethodWebRequest req = new PutMethodWebRequest("http://" + hostName + CONFIG_URL + '/' + path + parameter.getURLParameters(), (InputStream)new ByteArrayInputStream(value.getBytes(Charsets.UTF_8)), "application/octet-stream");
        WebResponse resp = conversation.getResponse((WebRequest)req);
        ConfigTools.assertEquals((String)"Response code is not okay.", (long)200L, (long)resp.getResponseCode());
        LOG.trace("Setting stored.");
    }

    @Deprecated
    public static int getUserId(WebConversation conversation, String hostName, String sessionId) throws IOException, SAXException, JSONException, OXException, OXException {
        AJAXConfig.init();
        AJAXSession session = new AJAXSession(conversation, hostName, sessionId);
        return Executor.execute(session, new GetRequest(Tree.Identifier), hostName).getInteger();
    }

    public static int getUserId(AJAXClient client) throws OXException, IOException, SAXException, JSONException {
        return client.getValues().getUserId();
    }

    public static TimeZone getTimeZone(WebConversation conversation, String hostName, String sessionId) throws IOException, SAXException, JSONException, OXException, OXException {
        AJAXConfig.init();
        AJAXSession session = new AJAXSession(conversation, hostName, sessionId);
        String value = ConfigTools.get(session, new GetRequest(Tree.TimeZone)).getString();
        return TimeZone.getTimeZone(value);
    }

    public static boolean getMailFilterValue(WebConversation conversation, String hostName, String sessionId) throws IOException, SAXException, JSONException, OXException, OXException {
        AJAXConfig.init();
        AJAXSession session = new AJAXSession(conversation, hostName, sessionId);
        Boolean value = ConfigTools.get(session, new GetRequest(Tree.MailFilter)).getBoolean();
        return value;
    }

    @Deprecated
    public static GetResponse get(AJAXClient client, GetRequest request) throws OXException, IOException, SAXException, JSONException {
        return client.execute(request);
    }

    public static GetResponse get(AJAXSession session, GetRequest request) throws OXException, IOException, SAXException, JSONException {
        return Executor.execute(session, request);
    }

    @Deprecated
    public static SetResponse set(AJAXClient client, SetRequest request) throws OXException, IOException, SAXException, JSONException {
        return client.execute(request);
    }

    public static GetResponse get(AJAXSession session, GetRequest request, String protocol, String hostname) throws OXException, IOException, SAXException, JSONException {
        if (protocol != null && hostname != null) {
            return Executor.execute(session, request, protocol, hostname);
        }
        return Executor.execute(session, request);
    }
}

