/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.ConflictObject;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class Bug44002Test
extends AbstractAJAXSession {
    private Appointment conflict;
    private Appointment series;
    private CalendarTestManager ctm;

    public Bug44002Test(String name) {
        super(name);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.client);
        this.conflict = new Appointment();
        this.series = new Appointment();
        Calendar c = Calendar.getInstance();
        c.set(7, 5);
        c.add(5, 7);
        c.set(11, 9);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        this.series.setTitle("Series next Thursday, weekly.");
        this.series.setStartDate(new Date(c.getTimeInMillis()));
        c.add(11, 1);
        this.series.setEndDate(new Date(c.getTimeInMillis()));
        this.series.setRecurrenceType(2);
        this.series.setDays(16);
        this.series.setInterval(1);
        this.series.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.series.setIgnoreConflicts(true);
        this.series.setAlarm(15);
        this.conflict.setTitle("Not matching appointment");
        c.add(5, 1);
        this.conflict.setStartDate(new Date(c.getTimeInMillis()));
        c.add(11, 1);
        this.conflict.setEndDate(new Date(c.getTimeInMillis()));
        this.conflict.setIgnoreConflicts(true);
        this.conflict.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.conflict.setAlarm(15);
        this.ctm.insert(this.series);
        this.ctm.insert(this.conflict);
    }

    @Test
    public void testBug44002() throws Exception {
        boolean old = false;
        if (old) {
            this.series.setRecurrenceType(0);
            this.series.removeInterval();
            this.series.removeDays();
            this.ctm.update(this.series);
        } else {
            Appointment updateForSeries = new Appointment();
            updateForSeries.setParentFolderID(this.series.getParentFolderID());
            updateForSeries.setObjectID(this.series.getObjectID());
            updateForSeries.setRecurrenceType(0);
            updateForSeries.setLastModified(this.series.getLastModified());
            updateForSeries.setIgnoreConflicts(false);
            this.ctm.update(updateForSeries);
        }
        List<ConflictObject> conflicts = this.ctm.getLastResponse().getConflicts();
        if (conflicts != null) {
            for (ConflictObject conf : conflicts) {
                if (conf.getId() != this.conflict.getObjectID()) continue;
                Bug44002Test.fail((String)"Should not conflict with appointment.");
            }
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }
}

