/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatesTest
extends AppointmentTest {
    private static final int[] _appointmentFields = new int[]{1, 2, 4, 5, 6, 3, 20, 101, 100, 200, 400, 201, 202, 203, 209, 215, 222, 220, 221, 204, 217, 402, 401, 102, 408, 410};
    private static final Logger LOG = LoggerFactory.getLogger(UpdatesTest.class);

    public UpdatesTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testDummy() throws Exception {
    }

    public void testModified() throws Exception {
        AppointmentTest.listModifiedAppointment(this.getWebConversation(), appointmentFolderId, new Date(), new Date(), new Date(System.currentTimeMillis() - 604800000L), _appointmentFields, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
    }

    public void testDeleted() throws Exception {
        AppointmentTest.listDeleteAppointment(this.getWebConversation(), appointmentFolderId, new Date(), new Date(), new Date(System.currentTimeMillis() - 604800000L), this.timeZone, "http://" + this.getHostName(), this.getSessionId());
    }

    public void testModifiedWithoutFolderId() throws Exception {
        Date start = new Date(System.currentTimeMillis() - 604800000L);
        Date end = new Date(System.currentTimeMillis() + 604800000L);
        Appointment appointmentObj = this.createAppointmentObject("testModifiedWithoutFolderId");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = AppointmentTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        Appointment loadAppointment = UpdatesTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, this.getHostName(), this.getSessionId());
        Date modified = loadAppointment.getLastModified();
        Appointment[] appointmentArray = AppointmentTest.listModifiedAppointment(this.getWebConversation(), start, end, UpdatesTest.decrementDate(modified), _appointmentFields, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        UpdatesTest.assertTrue((String)"no appointment object in response", (appointmentArray.length > 0 ? 1 : 0) != 0);
        boolean found = false;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            found = true;
        }
        UpdatesTest.assertTrue((String)"created object not found in response", (boolean)found);
        UpdatesTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.getHostName(), this.getSessionId(), false);
    }

    public void testModifiedWithoutFolderIdExtended() throws Exception {
        Date start = new Date(System.currentTimeMillis() - 604800000L);
        Date end = new Date(System.currentTimeMillis() + 604800000L);
        Appointment appointmentObj = this.createAppointmentObject("testModifiedWithoutFolderIdExtended");
        appointmentObj.setIgnoreConflicts(true);
        int objectId1 = AppointmentTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        Appointment loadAppointment = UpdatesTest.loadAppointment(this.getWebConversation(), objectId1, appointmentFolderId, this.timeZone, this.getHostName(), this.getSessionId());
        Date modified = loadAppointment.getLastModified();
        Appointment[] appointmentArray = AppointmentTest.listModifiedAppointment(this.getWebConversation(), start, end, UpdatesTest.decrementDate(modified), _appointmentFields, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        UpdatesTest.assertTrue((String)"no appointment object in response", (appointmentArray.length > 0 ? 1 : 0) != 0);
        boolean found1 = false;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId1) continue;
            found1 = true;
        }
        UpdatesTest.assertTrue((String)"created object not found in response", (boolean)found1);
        int objectId2 = AppointmentTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        loadAppointment = UpdatesTest.loadAppointment(this.getWebConversation(), objectId2, appointmentFolderId, this.timeZone, this.getHostName(), this.getSessionId());
        modified = loadAppointment.getLastModified();
        appointmentArray = AppointmentTest.listModifiedAppointment(this.getWebConversation(), start, end, UpdatesTest.decrementDate(modified), _appointmentFields, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        UpdatesTest.assertTrue((String)"no appointment object in response", (appointmentArray.length > 0 ? 1 : 0) != 0);
        found1 = false;
        boolean found2 = false;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() == objectId1) {
                found1 = true;
                continue;
            }
            if (appointmentArray[a].getObjectID() != objectId2) continue;
            found2 = true;
        }
        UpdatesTest.assertFalse((String)"invalid object id in reponse", (boolean)found1);
        UpdatesTest.assertTrue((String)"created object not found in response", (boolean)found2);
        UpdatesTest.deleteAppointment(this.getWebConversation(), objectId1, appointmentFolderId, this.getHostName(), this.getSessionId(), false);
        UpdatesTest.deleteAppointment(this.getWebConversation(), objectId2, appointmentFolderId, this.getHostName(), this.getSessionId(), false);
    }

    public void testModifiedWithoutFolderIdWithFutureTimestamp() throws Exception {
        Date start = new Date(System.currentTimeMillis() - 604800000L);
        Date end = new Date(System.currentTimeMillis() + 604800000L);
        Appointment appointmentObj = this.createAppointmentObject("testModifiedWithoutFolderIdWithFutureTimestamp");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = AppointmentTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        Appointment loadAppointment = UpdatesTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, this.getHostName(), this.getSessionId());
        Date modified = new Date(loadAppointment.getLastModified().getTime() + 604800000L);
        Appointment[] appointmentArray = AppointmentTest.listModifiedAppointment(this.getWebConversation(), start, end, modified, _appointmentFields, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        UpdatesTest.assertEquals((String)"unexpected data in response", (int)0, (int)appointmentArray.length);
        UpdatesTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.getHostName(), this.getSessionId(), false);
    }

    public void testModifiedRecurrenceAppointment() throws Exception {
        Date start = new Date(System.currentTimeMillis() - 604800000L);
        Date end = new Date(System.currentTimeMillis() + 604800000L);
        Appointment appointmentObj = this.createAppointmentObject("testModifiedRecurrenceAppointment");
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setOccurrence(5);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = AppointmentTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment[] appointmentArray = AppointmentTest.listModifiedAppointment(this.getWebConversation(), start, end, new Date(0L), _appointmentFields, this.timeZone, this.getHostName(), this.getSessionId());
        boolean found = false;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (objectId != appointmentArray[a].getObjectID()) continue;
            this.compareObject(appointmentObj, appointmentArray[a]);
            found = true;
            break;
        }
        UpdatesTest.assertTrue((String)("object with object_id: " + objectId + " not found in response"), (boolean)found);
        UpdatesTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.getHostName(), this.getSessionId(), false);
    }

    private static Date decrementDate(Date date) {
        return new Date(date.getTime() - 1L);
    }
}

