/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.ContactTest;
import com.openexchange.ajax.ResourceTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.group.GroupTest;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class UpdateTest
extends AppointmentTest {
    private static final int[] _appointmentFields = new int[]{1, 2, 4, 5, 3, 20, 101, 100, 200, 400, 201, 202, 203, 209, 215, 222, 220, 221, 402, 401, 102, 408, 410};

    public UpdateTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSimple() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testSimple");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = UpdateTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setShownAs(1);
        appointmentObj.setFullTime(true);
        appointmentObj.setLocation(null);
        appointmentObj.setObjectID(objectId);
        appointmentObj.removeParentFolderID();
        UpdateTest.updateAppointment(this.getWebConversation(), appointmentObj, objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        UpdateTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testUpdateAppointmentWithParticipant() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testUpdateAppointmentWithParticipants");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = UpdateTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setShownAs(1);
        appointmentObj.setFullTime(true);
        appointmentObj.setLocation(null);
        appointmentObj.setObjectID(objectId);
        int userParticipantId = ContactTest.searchContact(this.getWebConversation(), this.userParticipant3, 6, new int[]{524}, "http://" + this.getHostName(), this.getSessionId())[0].getInternalUserId();
        int groupParticipantId = GroupTest.searchGroup(this.getWebConversation(), this.groupParticipant, "http://", this.getHostName(), this.getSessionId())[0].getIdentifier();
        int resourceParticipantId = ResourceTest.searchResource(this.getWebConversation(), this.resourceParticipant, "http://" + this.getHostName(), this.getSessionId())[0].getIdentifier();
        Participant[] participants = new Participant[]{new UserParticipant(this.userId), new UserParticipant(userParticipantId), new GroupParticipant(groupParticipantId), new ResourceParticipant(resourceParticipantId)};
        appointmentObj.setParticipants(participants);
        appointmentObj.removeParentFolderID();
        UpdateTest.updateAppointment(this.getWebConversation(), appointmentObj, objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        UpdateTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testUpdateRecurrenceWithPosition() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 1296000000L);
        int changeExceptionPosition = 3;
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testUpdateRecurrence");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = UpdateTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = UpdateTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startTime, endTime);
        long newStartTime = startTime + 3600000L;
        long newEndTime = endTime + 3600000L;
        appointmentObj = new Appointment();
        appointmentObj.setTitle("testUpdateRecurrence - exception");
        appointmentObj.setStartDate(new Date(newStartTime));
        appointmentObj.setEndDate(new Date(newEndTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrencePosition(3);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        int newObjectId = UpdateTest.updateAppointment(this.getWebConversation(), appointmentObj, objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        UpdateTest.assertFalse((String)"object id of the update is equals with the old object id", (newObjectId == objectId ? 1 : 0) != 0);
        appointmentObj.setObjectID(newObjectId);
        loadAppointment = UpdateTest.loadAppointment(this.getWebConversation(), newObjectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, newStartTime, newEndTime);
        UpdateTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testShiftRecurrenceAppointment() throws Exception {
        Date start = new Date(System.currentTimeMillis() - 604800000L);
        Date end = new Date(System.currentTimeMillis() + 604800000L);
        Appointment appointmentObj = this.createAppointmentObject("testShiftRecurrenceAppointment");
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setOccurrence(5);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = AppointmentTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Date startDate = appointmentObj.getStartDate();
        Date endDate = appointmentObj.getEndDate();
        Calendar calendarStart = Calendar.getInstance(this.timeZone);
        Calendar calendarEnd = Calendar.getInstance(this.timeZone);
        calendarStart.setTime(startDate);
        calendarStart.add(5, 2);
        calendarEnd.setTime(endDate);
        calendarEnd.add(5, 2);
        appointmentObj.setStartDate(calendarStart.getTime());
        appointmentObj.setEndDate(calendarEnd.getTime());
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        Calendar recurrenceStart = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        int startDay = calendarStart.get(5);
        int startMonth = calendarStart.get(2);
        int startYear = calendarStart.get(1);
        recurrenceStart.set(startYear, startMonth, startDay, 0, 0, 0);
        recurrenceStart.set(14, 0);
        appointmentObj.setRecurringStart(recurrenceStart.getTimeInMillis());
        Appointment loadAppointment = UpdateTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, this.getHostName(), this.getSessionId());
        Date modified = loadAppointment.getLastModified();
        UpdateTest.updateAppointment(this.getWebConversation(), appointmentObj, objectId, appointmentFolderId, modified, this.timeZone, this.getHostName(), this.getSessionId());
        loadAppointment = UpdateTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, this.getHostName(), this.getSessionId());
        loadAppointment.removeUntil();
        this.compareObject(appointmentObj, loadAppointment);
        Appointment[] appointmentArray = AppointmentTest.listModifiedAppointment(this.getWebConversation(), start, end, new Date(0L), _appointmentFields, this.timeZone, this.getHostName(), this.getSessionId());
        boolean found = false;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (objectId != appointmentArray[a].getObjectID()) continue;
            this.compareObject(appointmentObj, appointmentArray[a]);
            found = true;
            break;
        }
        UpdateTest.assertTrue((String)("object with object_id: " + objectId + " not found in response"), (boolean)found);
        UpdateTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.getHostName(), this.getSessionId(), false);
    }

    public void testMakeFullTime() throws Exception {
        TimeZone utc = TimeZone.getTimeZone("urc");
        Appointment appointmentObj = this.createAppointmentObject("testShiftRecurrenceAppointment");
        appointmentObj.setStartDate(TimeTools.D("04/01/2008 12:00"));
        appointmentObj.setEndDate(TimeTools.D("04/01/2008 14:00"));
        appointmentObj.setIgnoreConflicts(true);
        int objectId = AppointmentTest.insertAppointment(this.getWebConversation(), appointmentObj, utc, this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment update = new Appointment();
        update.setObjectID(objectId);
        update.setParentFolderID(appointmentFolderId);
        update.setFullTime(true);
        Appointment loadAppointment = UpdateTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, utc, this.getHostName(), this.getSessionId());
        Date modified = new Date(Long.MAX_VALUE);
        UpdateTest.updateAppointment(this.getWebConversation(), update, objectId, appointmentFolderId, modified, utc, this.getHostName(), this.getSessionId());
        loadAppointment = UpdateTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, utc, this.getHostName(), this.getSessionId());
        GregorianCalendar check = new GregorianCalendar();
        ((Calendar)check).setTimeZone(utc);
        check.setTime(loadAppointment.getStartDate());
        UpdateTest.assertEquals((int)0, (int)check.get(11));
        UpdateTest.assertEquals((int)0, (int)check.get(12));
        UpdateTest.assertEquals((int)0, (int)check.get(13));
        UpdateTest.assertEquals((int)0, (int)check.get(14));
        check.setTime(loadAppointment.getEndDate());
        UpdateTest.assertEquals((int)0, (int)check.get(11));
        UpdateTest.assertEquals((int)0, (int)check.get(12));
        UpdateTest.assertEquals((int)0, (int)check.get(13));
        UpdateTest.assertEquals((int)0, (int)check.get(14));
    }
}

