/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.share;

import com.google.common.io.BaseEncoding;
import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class ShareTargetPath {
    private final int module;
    private final String folder;
    private final String item;
    private final Map<String, String> additionals;

    public ShareTargetPath(int module, String folder, String item) {
        this(module, folder, item, null);
    }

    public ShareTargetPath(int module, String folder, String item, Map<String, String> additionals) {
        this.module = module;
        this.folder = folder;
        this.item = item;
        this.additionals = additionals;
    }

    public int getModule() {
        return this.module;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getItem() {
        return this.item;
    }

    public Map<String, String> getAdditionals() {
        return this.additionals;
    }

    public boolean isFolder() {
        return this.item == null;
    }

    public String get() {
        List<String> segments;
        int version;
        if (null == this.additionals) {
            version = 1;
            segments = ShareTargetPath.encodeV1Segments(this);
        } else {
            version = 2;
            segments = ShareTargetPath.encodeV2Segments(this);
        }
        StringBuilder stringBuilder = new StringBuilder(64).append('/').append(version);
        for (String segment : segments) {
            stringBuilder.append('/').append(segment);
        }
        return stringBuilder.toString();
    }

    public static ShareTargetPath parse(String path) {
        return ShareTargetPath.parse(Strings.splitAndTrim((String)path, (String)"/"));
    }

    public static ShareTargetPath parse(List<String> segments) {
        try {
            Iterator<String> iterator = segments.iterator();
            int version = -1;
            while (iterator.hasNext()) {
                String segment = iterator.next();
                if (Strings.isEmpty((String)segment)) {
                    iterator.remove();
                    continue;
                }
                if (-1 != version) continue;
                version = Integer.valueOf(segment);
                iterator.remove();
            }
            switch (version) {
                case 1: {
                    return ShareTargetPath.decodeV1Segments(segments);
                }
                case 2: {
                    return ShareTargetPath.decodeV2Segments(segments);
                }
            }
            throw new IllegalArgumentException("Unknown path version: " + version);
        }
        catch (RuntimeException e) {
            LoggerFactory.getLogger(ShareTargetPath.class).debug("Error parsing share target path: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private static List<String> encodeV1Segments(ShareTargetPath path) {
        ArrayList<String> segments = new ArrayList<String>(3);
        segments.add(String.valueOf(path.getModule()));
        segments.add(ShareTargetPath.base64(path.getFolder(), true));
        if (null != path.getItem()) {
            segments.add(ShareTargetPath.base64(path.getItem(), true));
        }
        return segments;
    }

    private static ShareTargetPath decodeV1Segments(List<String> segments) {
        if (null == segments || 2 != segments.size() && 3 != segments.size()) {
            throw new IllegalArgumentException("Unexpected number of path segments");
        }
        int module = Integer.parseInt(segments.get(0));
        String folder = ShareTargetPath.base64(segments.get(1), false);
        String item = 3 == segments.size() ? ShareTargetPath.base64(segments.get(2), false) : null;
        return new ShareTargetPath(module, folder, item);
    }

    private static List<String> encodeV2Segments(ShareTargetPath path) {
        ArrayList<String> segments = new ArrayList<String>(4);
        segments.add('m' + String.valueOf(path.getModule()));
        segments.add('f' + ShareTargetPath.base64(path.getFolder(), true));
        if (null != path.getItem()) {
            segments.add('i' + ShareTargetPath.base64(path.getItem(), true));
        }
        if (null != path.getAdditionals() && 0 < path.getAdditionals().size()) {
            StringBuilder stringBuilder = new StringBuilder(64).append('a');
            ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(path.getAdditionals().entrySet());
            stringBuilder.append(ShareTargetPath.base64(entries.get(0).getKey(), true)).append('~').append(ShareTargetPath.base64(entries.get(0).getValue(), true));
            for (int i = 1; i < entries.size(); ++i) {
                stringBuilder.append('.').append(ShareTargetPath.base64(entries.get(i).getKey(), true)).append('~').append(ShareTargetPath.base64(entries.get(i).getValue(), true));
            }
            segments.add(stringBuilder.toString());
        }
        return segments;
    }

    private static ShareTargetPath decodeV2Segments(List<String> segments) {
        if (null == segments || 2 > segments.size()) {
            throw new IllegalArgumentException("Unexpected number of path segments");
        }
        int module = -1;
        String folder = null;
        String item = null;
        HashMap<String, String> meta = null;
        block6: for (String segment : segments) {
            if (null == segment || 2 > segment.length()) {
                throw new IllegalArgumentException("Unexpected segment length");
            }
            String value = segment.substring(1);
            switch (segment.charAt(0)) {
                case 'm': {
                    module = Integer.valueOf(value);
                    break;
                }
                case 'f': {
                    folder = ShareTargetPath.base64(value, false);
                    break;
                }
                case 'i': {
                    item = ShareTargetPath.base64(value, false);
                    break;
                }
                case 'a': {
                    String[] entries = Strings.splitByDots((String)value);
                    meta = new HashMap<String, String>(entries.length);
                    for (String entry : Strings.splitByDots((String)value)) {
                        int index = entry.indexOf(126);
                        meta.put(ShareTargetPath.base64(entry.substring(0, index), false), ShareTargetPath.base64(entry.substring(index + 1), false));
                    }
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected path segment: " + segment);
                }
            }
        }
        if (-1 == module || null == folder) {
            throw new IllegalArgumentException("Incomplete share target path");
        }
        return new ShareTargetPath(module, folder, item, meta);
    }

    private static String base64(String input, boolean encode) {
        if (input == null) {
            return null;
        }
        if (encode) {
            return BaseEncoding.base64Url().omitPadding().encode(input.getBytes(Charsets.UTF_8));
        }
        return new String(BaseEncoding.base64Url().omitPadding().decode((CharSequence)input), Charsets.UTF_8);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.folder == null ? 0 : this.folder.hashCode());
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        result = 31 * result + this.module;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShareTargetPath other = (ShareTargetPath)obj;
        if (this.folder == null ? other.folder != null : !this.folder.equals(other.folder)) {
            return false;
        }
        if (this.item == null ? other.item != null : !this.item.equals(other.item)) {
            return false;
        }
        return this.module == other.module;
    }

    public String toString() {
        return this.get();
    }
}

