/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.webdav.protocol.WebdavLock;

public class WebdavLockWriter {
    public String lock2xml(WebdavLock lock) {
        StringBuffer lockXML = new StringBuffer();
        this.activeLock(lockXML);
        this.lockType(lock, lockXML);
        this.lockScope(lock, lockXML);
        this.depth(lock, lockXML);
        this.owner(lock, lockXML);
        this.timeout(lock, lockXML);
        this.lockToken(lock, lockXML);
        this.endActiveLock(lockXML);
        return lockXML.toString();
    }

    private final void endActiveLock(StringBuffer lockXML) {
        lockXML.append("</D:activelock>");
    }

    private final void lockToken(WebdavLock lock, StringBuffer lockXML) {
        lockXML.append("<D:locktoken><D:href>");
        lockXML.append(lock.getToken());
        lockXML.append("</D:href></D:locktoken>");
    }

    private final void timeout(WebdavLock lock, StringBuffer lockXML) {
        lockXML.append("<D:timeout>");
        if (-1L == lock.getTimeout()) {
            lockXML.append("Infinite");
        } else {
            lockXML.append("Second-" + lock.getTimeout() / 1000L);
        }
        lockXML.append("</D:timeout>");
    }

    private final void owner(WebdavLock lock, StringBuffer lockXML) {
        lockXML.append("<D:owner>");
        lockXML.append(lock.getOwner());
        lockXML.append("</D:owner>");
    }

    private final void depth(WebdavLock lock, StringBuffer lockXML) {
        lockXML.append("<D:depth>");
        if (lock.getDepth() == -1) {
            lockXML.append("infinity");
        } else {
            lockXML.append(lock.getDepth());
        }
        lockXML.append("</D:depth>");
    }

    private final void lockScope(WebdavLock lock, StringBuffer lockXML) {
        lockXML.append("<D:lockscope>");
        if (lock.getScope().equals((Object)WebdavLock.Scope.EXCLUSIVE_LITERAL)) {
            lockXML.append("<D:exclusive/>");
        } else if (lock.getScope().equals((Object)WebdavLock.Scope.SHARED_LITERAL)) {
            lockXML.append("<D:shared/>");
        }
        lockXML.append("</D:lockscope>");
    }

    private final void lockType(WebdavLock lock, StringBuffer lockXML) {
        lockXML.append("<D:locktype>");
        if (lock.getType().equals((Object)WebdavLock.Type.WRITE_LITERAL)) {
            lockXML.append("<D:write />");
        }
        lockXML.append("</D:locktype>");
    }

    private final void activeLock(StringBuffer lockXML) {
        lockXML.append("<D:activelock>");
    }
}

