/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;

public class WebdavIfMatchAction
extends AbstractAction {
    private final int statusCode;

    public WebdavIfMatchAction() {
        this(412);
    }

    public WebdavIfMatchAction(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public void perform(WebdavRequest request, WebdavResponse response) throws WebdavProtocolException {
        this.check(request, true);
        this.check(request, false);
        this.yield(request, response);
    }

    private void check(WebdavRequest req, boolean mustMatch) throws WebdavProtocolException {
        String header = req.getHeader(mustMatch ? "If-Match" : "If-None-Match");
        if (null != header) {
            WebdavResource res = req.getResource();
            if (res.exists() && res.isCollection()) {
                throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 412);
            }
            boolean foundMatch = false;
            if (res.exists()) {
                String eTag = res.getETag();
                for (String tag : header.split("\\s*,\\s*")) {
                    if (null == tag || 0 >= tag.length() || !"*".equals(tag) && !eTag.equals(tag) && (!tag.startsWith("\"") || !tag.endsWith("\"") || 2 >= tag.length() || !eTag.equals(tag.substring(1, tag.length() - 1)))) continue;
                    foundMatch = true;
                    break;
                }
            }
            if (foundMatch != mustMatch) {
                throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), this.statusCode);
            }
        }
    }
}

