/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.sql;

import com.openexchange.database.Databases;
import com.openexchange.databaseold.Database;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.search.Order;
import com.openexchange.java.Strings;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DBUtils.class);
    public static final int IN_LIMIT = 1000;
    private static final Pattern PAT_TRUNCATED_IDS = Pattern.compile("([^']*')(\\S+)('[^']*)");

    private DBUtils() {
    }

    public static String getStatementString(Statement statement) {
        if (null == statement) {
            return null;
        }
        String str = statement.toString();
        int pos = str.indexOf(": ");
        return pos < 0 ? str : str.substring(pos + 2);
    }

    public static void closeSQLStuff(ResultSet result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (SQLException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    public static void closeSQLStuff(Statement stmt) {
        if (null != stmt) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    public static void closeSQLStuff(ResultSet result, Statement stmt) {
        DBUtils.closeSQLStuff(result);
        DBUtils.closeSQLStuff(stmt);
    }

    public static void closeResources(ResultSet rs, Statement stmt, Connection con, boolean isReadCon, Context ctx) {
        DBUtils.closeResources(rs, stmt, con, isReadCon, ctx.getContextId());
    }

    public static void closeResources(ResultSet rs, Statement stmt, Connection con, boolean isReadCon, int cid) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOG.error("", (Throwable)e);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.error("", (Throwable)e);
            }
        }
        if (con != null) {
            Database.back(cid, !isReadCon, con);
        }
    }

    public static String getStatement(Statement stmt) {
        return stmt == null ? "" : stmt.toString();
    }

    public static String getStatement(PreparedStatement stmt, String query) {
        if (stmt == null) {
            return query;
        }
        try {
            return stmt.toString();
        }
        catch (Exception x) {
            return query;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startTransaction(Connection con) throws SQLException {
        Statement stmt = null;
        try {
            con.setAutoCommit(false);
            stmt = con.createStatement();
            stmt.execute("START TRANSACTION");
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(stmt);
    }

    public static void rollback(Connection con) {
        if (null == con) {
            return;
        }
        try {
            if (!con.isClosed()) {
                con.rollback();
            }
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public static void autocommit(Connection con) {
        if (null == con) {
            return;
        }
        try {
            if (!con.isClosed()) {
                con.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public static String[] parseTruncatedFields(DataTruncation trunc) {
        Matcher matcher = PAT_TRUNCATED_IDS.matcher(trunc.getMessage());
        ArrayList<String> retval = new ArrayList<String>();
        if (matcher.find()) {
            for (int i = 2; i < matcher.groupCount(); ++i) {
                retval.add(matcher.group(i));
            }
        }
        return retval.toArray(new String[retval.size()]);
    }

    public static String getIN(String sql, int length) {
        return DBUtils.getIN(sql, length, null);
    }

    public static String getIN(String sql, int length, String appendix) {
        if (length <= 0) {
            return sql;
        }
        StringBuilder retval = new StringBuilder(sql);
        retval.append('?');
        for (int i = 1; i < length; ++i) {
            retval.append(",?");
        }
        retval.append(')');
        if (null != appendix) {
            if (!appendix.startsWith(" ")) {
                retval.append(" ");
            }
            retval.append(appendix);
        }
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getColumnSize(Connection con, String table, String column) throws SQLException {
        int n;
        DatabaseMetaData metas = con.getMetaData();
        ResultSet result = null;
        try {
            result = metas.getColumns(null, null, table, column);
            int retval = -1;
            if (result.next()) {
                retval = result.getInt("COLUMN_SIZE");
            }
            n = retval;
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result);
        return n;
    }

    public static Set<String> existingTables(Connection con, String ... tablesToCheck) throws SQLException {
        HashSet<String> tables = new HashSet<String>();
        for (String table : tablesToCheck) {
            if (!DBUtils.tableExists(con, table)) continue;
            tables.add(table);
        }
        return tables;
    }

    public static boolean tablesExist(Connection con, String ... tablesToCheck) throws SQLException {
        for (String table : tablesToCheck) {
            if (DBUtils.tableExists(con, table)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(Connection con, String table) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet rs = null;
        boolean retval = false;
        try {
            rs = metaData.getTables(null, null, table, new String[]{"TABLE"});
            retval = rs.next() && rs.getString("TABLE_NAME").equals(table);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean procedureExists(Connection con, String procedure) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet rs = null;
        boolean retval = false;
        try {
            rs = metaData.getProcedures(null, null, procedure);
            retval = rs.next() && rs.getString("PROCEDURE_NAME").equals(procedure);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs);
        return retval;
    }

    public static String forSQLCommand(Order order) {
        if (order != null) {
            switch (order) {
                case ASCENDING: {
                    return " ASC ";
                }
                case DESCENDING: {
                    return " DESC ";
                }
                case NO_ORDER: {
                    return " ";
                }
            }
        }
        return " ";
    }

    public static void disableMysqlForeignKeyChecks(Connection connection) throws SQLException {
        DBUtils.setMysqlForeignKeyChecks(connection, 0);
    }

    public static void enableMysqlForeignKeyChecks(Connection connection) throws SQLException {
        DBUtils.setMysqlForeignKeyChecks(connection, 1);
    }

    private static void setMysqlForeignKeyChecks(Connection connection, int value) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("SET @@foreign_key_checks = " + value);
        statement.close();
    }

    public static boolean isPrimaryKeyConflictInMySQL(SQLException e) {
        return Databases.isPrimaryKeyConflictInMySQL((SQLException)e);
    }

    public static boolean isKeyConflictInMySQL(SQLException e, String keyName) {
        return Databases.isKeyConflictInMySQL((SQLException)e, (String)keyName);
    }

    public static boolean isTransactionRollbackException(SQLException sqlException) {
        if (null == sqlException) {
            return false;
        }
        if (DBUtils.suggestsRestartingTransaction(sqlException) || sqlException.getClass().getName().endsWith("TransactionRollbackException")) {
            return true;
        }
        if (DBUtils.isTransactionRollbackException(sqlException.getNextException())) {
            return true;
        }
        Throwable cause = sqlException.getCause();
        if (null == cause || !(cause instanceof Exception)) {
            return false;
        }
        return DBUtils.isTransactionRollbackException((Exception)cause);
    }

    public static boolean isTransactionRollbackException(Exception exception) {
        if (null == exception) {
            return false;
        }
        if (exception instanceof SQLException) {
            return DBUtils.isTransactionRollbackException((SQLException)exception);
        }
        Throwable cause = exception.getCause();
        if (null == cause || !(cause instanceof Exception)) {
            return false;
        }
        return DBUtils.isTransactionRollbackException((Exception)cause);
    }

    public static boolean suggestsRestartingTransaction(SQLException sqlException) {
        String message = null == sqlException ? null : sqlException.getMessage();
        return null != message && Strings.asciiLowerCase((String)message).indexOf("try restarting transaction") >= 0;
    }

    public static SQLException extractSqlException(Exception exception) {
        if (null == exception) {
            return null;
        }
        if (exception instanceof SQLException) {
            return (SQLException)exception;
        }
        Throwable cause = exception.getCause();
        if (null == cause || !(cause instanceof Exception)) {
            return null;
        }
        return DBUtils.extractSqlException((Exception)cause);
    }

    public static final class TransactionRollbackCondition {
        private final int max;
        private int count = 0;
        private SQLException transactionRollbackException;

        public TransactionRollbackCondition(int max) {
            this.max = max;
        }

        public boolean isFailedTransactionRollback(SQLException e) {
            if (DBUtils.isTransactionRollbackException(e)) {
                this.transactionRollbackException = e;
                return true;
            }
            return false;
        }

        public boolean isFailedTransactionRollback(Exception e) {
            SQLException sqle = DBUtils.extractSqlException(e);
            if (null != sqle && DBUtils.isTransactionRollbackException(sqle)) {
                this.transactionRollbackException = sqle;
                return true;
            }
            return false;
        }

        public SQLException getTransactionRollbackException() {
            return this.transactionRollbackException;
        }

        public void resetTransactionRollbackException() {
            this.transactionRollbackException = null;
        }

        public boolean checkRetry() throws SQLException {
            if (null == this.transactionRollbackException) {
                return false;
            }
            if (++this.count <= this.max) {
                this.transactionRollbackException = null;
                return true;
            }
            throw this.transactionRollbackException;
        }
    }
}

