/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.encoding;

public class Hex {
    private Hex() {
    }

    public static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            if (b[i] < 16 && b[i] >= 0) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(b[i] < 0 ? 256 + b[i] : b[i]));
        }
        return sb.toString();
    }

    public static String toHex(byte b) {
        StringBuffer sb = new StringBuffer(2);
        if (b >= 0 && b < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(b < 0 ? 256 + b : b));
        return sb.toString();
    }

    public static byte[] toByteArray(String hex) throws NumberFormatException {
        int length = hex.length() >> 1;
        byte[] retval = new byte[length];
        for (int i = 0; i < length; ++i) {
            retval[i] = Hex.toByte(hex.substring(i << 1, (i << 1) + 2));
        }
        return retval;
    }

    public static byte toByte(String hex) {
        int value = Integer.parseInt(hex, 16);
        return (byte)(value < 128 ? value : value - 256);
    }
}

