/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.services;

import com.openexchange.i18n.I18nService;
import com.openexchange.i18n.LocaleTools;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nServices {
    private static final Logger LOG = LoggerFactory.getLogger(I18nServices.class);
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static final I18nServices SINGLETON = new I18nServices();
    private final Map<Locale, I18nService> services = new ConcurrentHashMap<Locale, I18nService>(32, 0.9f, 1);

    private I18nServices() {
    }

    public void addService(I18nService service) {
        if (null != this.services.put(service.getLocale(), service)) {
            LOG.warn("Another i18n translation service found for {}", (Object)service.getLocale());
        }
    }

    public void removeService(I18nService service) {
        if (null == this.services.remove(service.getLocale())) {
            LOG.warn("Unknown i18n translation service shut down for {}", (Object)service.getLocale());
        }
    }

    public static I18nServices getInstance() {
        return SINGLETON;
    }

    public I18nService getService(Locale locale) {
        return this.getService(null == locale ? DEFAULT_LOCALE : locale, true);
    }

    public I18nService getService(Locale locale, boolean warn) {
        Locale loc = null == locale ? DEFAULT_LOCALE : locale;
        I18nService retval = this.services.get(loc);
        if (warn && null == retval && !"en".equalsIgnoreCase(loc.getLanguage())) {
            LOG.warn("No i18n service for locale {}.", (Object)loc);
        }
        return retval;
    }

    public String translate(Locale locale, String toTranslate) {
        return this.translate(locale, toTranslate, true);
    }

    public String translate(Locale locale, String toTranslate, boolean warn) {
        Locale loc = null == locale ? DEFAULT_LOCALE : locale;
        I18nService service = this.getService(loc, warn);
        if (null == service) {
            return toTranslate;
        }
        if (warn && !service.hasKey(toTranslate)) {
            LOG.debug("I18n service for locale {} has no translation for \"{}\".", (Object)loc, (Object)toTranslate);
            return toTranslate;
        }
        return service.getLocalized(toTranslate);
    }

    public String translate(String localeId, String toTranslate) {
        return this.translate(LocaleTools.getLocale((String)localeId), toTranslate);
    }

    public void clear() {
        this.services.clear();
    }
}

