/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.resource.Resource;
import com.openexchange.resource.internal.ResourceServiceImpl;
import com.openexchange.resource.json.ResourceAJAXRequest;
import com.openexchange.resource.json.actions.AbstractResourceAction;
import com.openexchange.server.ServiceLookup;
import java.util.Date;
import java.util.LinkedList;
import org.json.JSONException;

@Action(method=RequestMethod.GET, name="all", description="Get all resources", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, responseDescription="An array of resource identifier.")
public final class AllAction
extends AbstractResourceAction {
    private static final String STR_ALL = "*";

    public AllAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(ResourceAJAXRequest req) throws OXException, JSONException {
        Date timestamp;
        Resource[] resources = ResourceServiceImpl.getInstance().searchResources(STR_ALL, req.getSession().getContext());
        LinkedList<Resource> list = new LinkedList<Resource>();
        if (resources.length > 0) {
            long lastModified = Long.MIN_VALUE;
            for (Resource resource : resources) {
                if (lastModified < resource.getLastModified().getTime()) {
                    lastModified = resource.getLastModified().getTime();
                }
                list.add(resource);
            }
            timestamp = new Date(lastModified);
        } else {
            timestamp = new Date(0L);
        }
        return new AJAXRequestResult(list, timestamp, "resource");
    }
}

