/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.preferences;

import com.openexchange.config.ConfigurationService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.settings.SettingExceptionCodes;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.util.UUIDs;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUserSetting {
    private static final Logger LOG = LoggerFactory.getLogger(ServerUserSetting.class);
    private static final Attribute<Boolean> CONTACT_COLLECT_ENABLED = new Attribute<Boolean>(){

        @Override
        public Boolean getAttribute(ResultSet rs) throws SQLException {
            return rs.getBoolean(this.getColumnName());
        }

        @Override
        public String getColumnName() {
            return "contact_collect_enabled";
        }

        @Override
        public void setAttribute(PreparedStatement pstmt, Boolean value) throws SQLException {
            if (null == value) {
                pstmt.setNull(1, 16);
            } else {
                pstmt.setBoolean(1, value);
            }
        }
    };
    private static final Attribute<Integer> CONTACT_COLLECT_FOLDER = new Attribute<Integer>(){

        @Override
        public Integer getAttribute(ResultSet rs) throws SQLException {
            int retval = rs.getInt(this.getColumnName());
            return rs.wasNull() ? null : Autoboxing.I((int)retval);
        }

        @Override
        public String getColumnName() {
            return "contact_collect_folder";
        }

        @Override
        public void setAttribute(PreparedStatement pstmt, Integer value) throws SQLException {
            if (null == value) {
                pstmt.setNull(1, 4);
            } else {
                pstmt.setInt(1, value);
            }
        }
    };
    private static final Attribute<Boolean> CONTACT_COLLECT_ON_MAIL_ACCESS = new Attribute<Boolean>(){

        @Override
        public Boolean getAttribute(ResultSet rs) throws SQLException {
            boolean b = rs.getBoolean(this.getColumnName());
            return rs.wasNull() ? null : Boolean.valueOf(b);
        }

        @Override
        public String getColumnName() {
            return "contactCollectOnMailAccess";
        }

        @Override
        public void setAttribute(PreparedStatement pstmt, Boolean value) throws SQLException {
            if (value == null) {
                pstmt.setBoolean(1, true);
            } else {
                pstmt.setBoolean(1, value);
            }
        }
    };
    private static final Attribute<Boolean> CONTACT_COLLECT_ON_MAIL_TRANSPORT = new Attribute<Boolean>(){

        @Override
        public Boolean getAttribute(ResultSet rs) throws SQLException {
            boolean b = rs.getBoolean(this.getColumnName());
            return rs.wasNull() ? null : Boolean.valueOf(b);
        }

        @Override
        public String getColumnName() {
            return "contactCollectOnMailTransport";
        }

        @Override
        public void setAttribute(PreparedStatement pstmt, Boolean value) throws SQLException {
            if (value == null) {
                pstmt.setBoolean(1, true);
            } else {
                pstmt.setBoolean(1, value);
            }
        }
    };
    private static final Attribute<Integer> DEFAULT_STATUS_PRIVATE = new Attribute<Integer>(){

        @Override
        public Integer getAttribute(ResultSet rs) throws SQLException {
            return Autoboxing.I((int)rs.getInt(this.getColumnName()));
        }

        @Override
        public String getColumnName() {
            return "defaultStatusPrivate";
        }

        @Override
        public void setAttribute(PreparedStatement pstmt, Integer value) throws SQLException {
            if (value == null) {
                pstmt.setInt(1, 0);
            } else {
                pstmt.setInt(1, value);
            }
        }
    };
    private static final Attribute<Integer> DEFAULT_STATUS_PUBLIC = new Attribute<Integer>(){

        @Override
        public Integer getAttribute(ResultSet rs) throws SQLException {
            return Autoboxing.I((int)rs.getInt(this.getColumnName()));
        }

        @Override
        public String getColumnName() {
            return "defaultStatusPublic";
        }

        @Override
        public void setAttribute(PreparedStatement pstmt, Integer value) throws SQLException {
            if (value == null) {
                pstmt.setInt(1, 0);
            } else {
                pstmt.setInt(1, value);
            }
        }
    };
    private static final Attribute<Integer> FOLDER_TREE = new Attribute<Integer>(){

        @Override
        public Integer getAttribute(ResultSet rs) throws SQLException {
            int tmp = rs.getInt(this.getColumnName());
            Integer retval = rs.wasNull() ? null : Autoboxing.I((int)tmp);
            return retval;
        }

        @Override
        public String getColumnName() {
            return "folderTree";
        }

        @Override
        public void setAttribute(PreparedStatement pstmt, Integer value) throws SQLException {
            if (value == null) {
                pstmt.setInt(1, 0);
            } else {
                pstmt.setInt(1, value);
            }
        }
    };
    private static final ServerUserSetting defaultInstance = new ServerUserSetting();
    private final Connection connection;

    public static ServerUserSetting getInstance() {
        return defaultInstance;
    }

    public static ServerUserSetting getInstance(Connection connection) {
        return new ServerUserSetting(connection);
    }

    private ServerUserSetting() {
        this(null);
    }

    private ServerUserSetting(Connection connection) {
        this.connection = connection;
    }

    public void setContactCollectionFolder(int contextId, int userId, Integer folder) throws OXException {
        this.setAttribute(contextId, userId, CONTACT_COLLECT_FOLDER, folder);
    }

    public Integer getContactCollectionFolder(int contextId, int userId) throws OXException {
        return this.getAttribute(contextId, userId, CONTACT_COLLECT_FOLDER);
    }

    public void setContactCollectOnMailAccess(int contextId, int userId, boolean value) throws OXException {
        this.setAttribute(contextId, userId, CONTACT_COLLECT_ON_MAIL_ACCESS, value);
    }

    public Boolean isContactCollectOnMailAccess(int contextId, int userId) throws OXException {
        Boolean attribute = this.getAttribute(contextId, userId, CONTACT_COLLECT_ON_MAIL_ACCESS);
        if (null != attribute) {
            return attribute;
        }
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        return null == service ? Boolean.FALSE : Boolean.valueOf(service.getBoolProperty("com.openexchange.user.contactCollectOnMailAccess", false));
    }

    public void setContactCollectOnMailTransport(int contextId, int userId, boolean value) throws OXException {
        this.setAttribute(contextId, userId, CONTACT_COLLECT_ON_MAIL_TRANSPORT, value);
    }

    public Boolean isContactCollectOnMailTransport(int contextId, int userId) throws OXException {
        Boolean attribute = this.getAttribute(contextId, userId, CONTACT_COLLECT_ON_MAIL_TRANSPORT);
        if (null != attribute) {
            return attribute;
        }
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        return null == service ? Boolean.FALSE : Boolean.valueOf(service.getBoolProperty("com.openexchange.user.contactCollectOnMailTransport", false));
    }

    public Integer getDefaultStatusPrivate(int contextId, int userId) throws OXException {
        Integer value = this.getAttribute(contextId, userId, DEFAULT_STATUS_PRIVATE);
        if (value == null) {
            value = Autoboxing.I((int)0);
        }
        return value;
    }

    public void setDefaultStatusPrivate(int contextId, int userId, Integer status) throws OXException {
        this.setAttribute(contextId, userId, DEFAULT_STATUS_PRIVATE, status);
    }

    public Integer getDefaultStatusPublic(int contextId, int userId) throws OXException {
        Integer value = this.getAttribute(contextId, userId, DEFAULT_STATUS_PUBLIC);
        if (value == null) {
            value = Autoboxing.I((int)0);
        }
        return value;
    }

    public void setDefaultStatusPublic(int contextId, int userId, Integer status) throws OXException {
        this.setAttribute(contextId, userId, DEFAULT_STATUS_PUBLIC, status);
    }

    public Integer getFolderTree(int contextId, int userId) throws OXException {
        return this.getAttribute(contextId, userId, FOLDER_TREE);
    }

    public void setFolderTree(int contextId, int userId, Integer value) throws OXException {
        this.setAttribute(contextId, userId, FOLDER_TREE, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getAttribute(int contextId, int userId, Attribute<T> attribute) throws OXException {
        Connection con = this.connection == null ? Database.get(contextId, false) : this.connection;
        try {
            T t = this.getAttribute(contextId, userId, attribute, con);
            return t;
        }
        finally {
            if (null == this.connection) {
                Database.back(contextId, false, con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void setAttribute(int contextId, int userId, Attribute<T> attribute, T value) throws OXException {
        Connection con = this.connection == null ? Database.get(contextId, true) : this.connection;
        try {
            if (this.hasEntry(contextId, userId, con)) {
                this.updateAttribute(contextId, userId, attribute, value, con);
            } else {
                this.insertAttribute(contextId, userId, attribute, value, con);
            }
        }
        finally {
            if (null == this.connection) {
                Database.back(contextId, true, con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteEntry(int contextId, int userId) throws OXException {
        Connection con = this.connection == null ? Database.get(contextId, true) : this.connection;
        try {
            this.deleteEntry(contextId, userId, con);
        }
        finally {
            if (null == this.connection) {
                Database.back(contextId, true, con);
            }
        }
    }

    private <T> T getAttribute(int contextId, int userId, Attribute<T> attribute, Connection con) throws OXException {
        T retval = null;
        String select = "SELECT " + attribute.getColumnName() + " FROM user_setting_server WHERE cid=? AND user=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(select);
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                retval = attribute.getAttribute(rs);
            }
        }
        catch (SQLException e) {
            try {
                throw SettingExceptionCodes.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return retval;
    }

    private <T> void updateAttribute(int contextId, int userId, Attribute<T> attribute, T value, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE user_setting_server SET " + attribute.getColumnName() + "=? WHERE cid=? AND user=?");
            attribute.setAttribute(stmt, value);
            stmt.setInt(2, contextId);
            stmt.setInt(3, userId);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw SettingExceptionCodes.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
    }

    private <T> void insertAttribute(int contextId, int userId, Attribute<T> attribute, T value, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            ConfigurationService service;
            int pos = 2;
            String start = "INSERT INTO user_setting_server (" + attribute.getColumnName();
            if (CONTACT_COLLECT_ON_MAIL_ACCESS.equals(attribute)) {
                stmt = con.prepareStatement(start + ",contactCollectOnMailTransport,cid,user, uuid) VALUES (?,?,?,?,?)");
                attribute.setAttribute(stmt, value);
                service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
                boolean b = null == service ? false : service.getBoolProperty("com.openexchange.user.contactCollectOnMailTransport", false);
                stmt.setBoolean(pos++, b);
            } else if (CONTACT_COLLECT_ON_MAIL_TRANSPORT.equals(attribute)) {
                stmt = con.prepareStatement(start + ",contactCollectOnMailAccess,cid,user, uuid) VALUES (?,?,?,?,?)");
                attribute.setAttribute(stmt, value);
                service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
                boolean b = null == service ? false : service.getBoolProperty("com.openexchange.user.contactCollectOnMailAccess", false);
                stmt.setBoolean(pos++, b);
            } else {
                stmt = con.prepareStatement(start + ",contactCollectOnMailAccess,contactCollectOnMailTransport,cid,user, uuid) VALUES (?,?,?,?,?,?)");
                attribute.setAttribute(stmt, value);
                service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
                boolean b = null == service ? false : service.getBoolProperty("com.openexchange.user.contactCollectOnMailAccess", false);
                stmt.setBoolean(pos++, b);
                b = null == service ? false : service.getBoolProperty("com.openexchange.user.contactCollectOnMailTransport", false);
                stmt.setBoolean(pos++, b);
            }
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            UUID uuid = UUID.randomUUID();
            byte[] uuidBinary = UUIDs.toByteArray((UUID)uuid);
            stmt.setBytes(pos, uuidBinary);
            LOG.debug("INSERTing user settings: {}", (Object)DBUtils.getStatementString(stmt));
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw SettingExceptionCodes.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    private void deleteEntry(int contextId, int userId, Connection con) throws OXException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("DELETE FROM user_setting_server WHERE cid=? AND user=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw SettingExceptionCodes.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            DBUtils.closeSQLStuff(rs, stmt);
        }
    }

    private boolean hasEntry(int contextId, int userId, Connection con) throws OXException {
        boolean retval = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT 1 FROM user_setting_server WHERE cid=? AND user=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            retval = rs.next();
        }
        catch (SQLException e) {
            try {
                throw SettingExceptionCodes.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return retval;
    }

    private static interface Attribute<T> {
        public void setAttribute(PreparedStatement var1, T var2) throws SQLException;

        public T getAttribute(ResultSet var1) throws SQLException;

        public String getColumnName();
    }
}

