/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.utils;

import com.openexchange.config.ConfigurationService;
import com.openexchange.java.Strings;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.HostList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MailAccountUtils {
    private static volatile HostList blacklistedHosts;
    private static volatile Set<Integer> allowedPorts;

    private MailAccountUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HostList blacklistedHosts() {
        HostList tmp = blacklistedHosts;
        if (null != tmp) return tmp;
        Class<MailAccountUtils> clazz = MailAccountUtils.class;
        synchronized (MailAccountUtils.class) {
            tmp = blacklistedHosts;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return HostList.EMPTY;
            }
            String prop = service.getProperty("com.openexchange.mail.account.blacklist");
            blacklistedHosts = tmp = HostList.valueOf(prop);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Set<Integer> allowedPorts() {
        Set<Integer> tmp = allowedPorts;
        if (null != tmp) return tmp;
        Class<MailAccountUtils> clazz = MailAccountUtils.class;
        synchronized (MailAccountUtils.class) {
            tmp = allowedPorts;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Collections.emptySet();
            }
            String prop = service.getProperty("com.openexchange.mail.account.whitelist.ports");
            if (Strings.isEmpty((String)prop)) {
                tmp = Collections.emptySet();
            } else {
                String[] tokens = Strings.splitByComma((String)prop);
                tmp = new HashSet<Integer>(tokens.length);
                for (String token : tokens) {
                    if (Strings.isEmpty((String)token)) continue;
                    try {
                        tmp.add(Integer.valueOf(token.trim()));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            allowedPorts = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    public static boolean isDenied(String hostName, int port) {
        return false == MailAccountUtils.isAllowed(port) || MailAccountUtils.isBlacklisted(hostName);
    }

    public static boolean isBlacklisted(String hostName) {
        if (Strings.isEmpty((String)hostName)) {
            return false;
        }
        return MailAccountUtils.blacklistedHosts().contains(hostName);
    }

    public static boolean isAllowed(int port) {
        if (port < 0) {
            return true;
        }
        if (port > 65535) {
            return false;
        }
        Set<Integer> allowedPorts = MailAccountUtils.allowedPorts();
        return allowedPorts.isEmpty() ? true : allowedPorts.contains(port);
    }
}

