/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.internal;

import com.openexchange.java.Strings;
import com.openexchange.mailaccount.TransportAccount;
import com.openexchange.mailaccount.TransportAuth;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.net.URIParser;
import com.openexchange.tools.net.URITools;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.idn.IDNA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportAccountImpl
implements TransportAccount {
    private static final Logger LOG = LoggerFactory.getLogger(TransportAccount.class);
    private static final long serialVersionUID = -402344252962912219L;
    private int id = -1;
    private String name;
    private String personal;
    private String replyTo;
    private String sentAddress;
    private TransportAuth transportAuth;
    private String transportLogin;
    private String transportPassword;
    private int transportPort;
    private Map<String, String> transportProperties;
    private String transportProtocol;
    private boolean transportSecure;
    private String transportServer;
    private String transportServerUrl;
    private boolean transportStartTls;

    @Override
    public String generateTransportServerURL() {
        if (null != this.transportServerUrl) {
            return this.transportServerUrl;
        }
        if (Strings.isEmpty((String)this.transportServer)) {
            return null;
        }
        String protocol = this.transportSecure ? this.transportProtocol + 's' : this.transportProtocol;
        try {
            this.transportServerUrl = URITools.generateURI(protocol, IDNA.toASCII((String)this.transportServer), this.transportPort).toString();
            return this.transportServerUrl;
        }
        catch (URISyntaxException e) {
            LOG.error("", (Throwable)e);
            StringBuilder sb = new StringBuilder(32);
            sb.append(this.transportProtocol);
            if (this.transportSecure) {
                sb.append('s');
            }
            this.transportServerUrl = sb.append("://").append(this.transportServer).append(':').append(this.transportPort).toString();
            return this.transportServerUrl;
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getLogin() {
        return this.getTransportLogin();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPassword() {
        return this.getTransportPassword();
    }

    @Override
    public String getPrimaryAddress() {
        return this.sentAddress;
    }

    @Override
    public TransportAuth getTransportAuth() {
        return this.transportAuth;
    }

    @Override
    public String getTransportLogin() {
        return this.transportLogin;
    }

    @Override
    public String getTransportPassword() {
        return this.transportPassword;
    }

    @Override
    public int getTransportPort() {
        return this.transportPort;
    }

    @Override
    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    @Override
    public String getTransportServer() {
        return this.transportServer;
    }

    @Override
    public boolean isDefaultAccount() {
        return this.id == 0;
    }

    @Override
    public boolean isTransportStartTls() {
        return this.transportStartTls;
    }

    @Override
    public void parseTransportServerURL(String transportServerURL) {
        if (null == transportServerURL) {
            this.setTransportServer((String)null);
            return;
        }
        try {
            this.setTransportServer(URIParser.parse(IDNA.toASCII((String)transportServerURL), URIDefaults.SMTP));
        }
        catch (URISyntaxException e) {
            this.setTransportServer((String)null);
            return;
        }
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }

    @Override
    public String getPersonal() {
        return this.personal;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    @Override
    public String getReplyTo() {
        return this.replyTo;
    }

    public void setTransportAuth(TransportAuth transportAuth) {
        this.transportAuth = transportAuth;
    }

    public void setTransportLogin(String login) {
        this.transportLogin = login;
    }

    public void setTransportPassword(String transportPassword) {
        this.transportPassword = transportPassword;
    }

    public void setTransportPort(int transportPort) {
        this.transportServerUrl = null;
        this.transportPort = transportPort;
    }

    public void setTransportProperties(Map<String, String> transportProperties) {
        this.transportProperties = null == transportProperties ? new HashMap<String, String>(4) : (transportProperties.isEmpty() ? new HashMap<String, String>(4) : new HashMap<String, String>(transportProperties));
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportServerUrl = null;
        this.transportProtocol = transportProtocol;
    }

    public void setTransportSecure(boolean transportSecure) {
        this.transportServerUrl = null;
        this.transportSecure = transportSecure;
    }

    @Override
    public boolean isTransportSecure() {
        return this.transportSecure;
    }

    public void setTransportServer(String transportServer) {
        this.transportServerUrl = null;
        this.transportServer = transportServer == null ? null : IDNA.toUnicode((String)transportServer);
    }

    public void setTransportServer(URI transportServer) {
        if (null == transportServer) {
            this.setTransportServer("");
        } else {
            String protocol = transportServer.getScheme();
            if (protocol.endsWith("s")) {
                this.setTransportSecure(true);
                this.setTransportProtocol(protocol.substring(0, protocol.length() - 1));
            } else {
                this.setTransportSecure(false);
                this.setTransportProtocol(protocol);
            }
            this.setTransportServer(URITools.getHost(transportServer));
            this.setTransportPort(transportServer.getPort());
        }
    }

    public void setTransportStartTls(boolean startTLS) {
        this.transportStartTls = startTLS;
    }
}

