/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import java.util.Collection;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.FlagTerm;
import org.slf4j.LoggerFactory;

public final class UserFlagTerm
extends SearchTerm<String[]> {
    private static final long serialVersionUID = -6887694637971347838L;
    private final boolean set;
    private final String[] userFlags;

    public UserFlagTerm(String userFlag, boolean set) {
        if (Strings.isEmpty((String)userFlag)) {
            throw new IllegalArgumentException("User flag must not be null or empty");
        }
        this.userFlags = new String[]{userFlag};
        this.set = set;
    }

    public UserFlagTerm(String[] userFlags, boolean set) {
        if (null == userFlags || 0 == userFlags.length) {
            throw new IllegalArgumentException("User flags must not be null or empty");
        }
        int i = userFlags.length;
        while (i-- > 0) {
            if (!Strings.isEmpty((String)userFlags[i])) continue;
            throw new IllegalArgumentException("User flag must not be null or empty");
        }
        this.userFlags = userFlags;
        this.set = set;
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    public boolean isSet() {
        return this.set;
    }

    @Override
    public String[] getPattern() {
        return this.userFlags;
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.FLAGS);
    }

    @Override
    public boolean matches(MailMessage mailMessage) {
        String[] userFlags = mailMessage.getUserFlags();
        if (null == userFlags) {
            return false;
        }
        String[] thisUserFlags = this.userFlags;
        int i = thisUserFlags.length;
        while (i-- > 0) {
            if (!(this.set ? !this.contains(thisUserFlags[i], userFlags) : this.contains(thisUserFlags[i], userFlags))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        Flags msgFlags;
        Flags flagsObj = new Flags();
        String[] thisUserFlags = this.userFlags;
        int i = thisUserFlags.length;
        int k = 0;
        while (i-- > 0) {
            flagsObj.add(thisUserFlags[k++]);
        }
        try {
            msgFlags = msg.getFlags();
        }
        catch (MessagingException e) {
            LoggerFactory.getLogger(UserFlagTerm.class).warn("Error during search.", (Throwable)e);
            return false;
        }
        return this.set ? msgFlags.contains(flagsObj) : !msgFlags.contains(flagsObj);
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        Flags flagsObj = new Flags();
        String[] thisUserFlags = this.userFlags;
        int i = thisUserFlags.length;
        int k = 0;
        while (i-- > 0) {
            flagsObj.add(thisUserFlags[k++]);
        }
        return new FlagTerm(flagsObj, this.set);
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return this.getJavaMailSearchTerm();
    }

    @Override
    public void contributeTo(FetchProfile fetchProfile) {
        if (!fetchProfile.contains(FetchProfile.Item.FLAGS)) {
            fetchProfile.add(FetchProfile.Item.FLAGS);
        }
    }

    private boolean contains(String userFlag, String[] userFlags) {
        if (null != userFlag) {
            int i = userFlags.length;
            while (i-- > 0) {
                if (!userFlag.equals(userFlags[i])) continue;
                return true;
            }
        }
        return false;
    }
}

