/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import java.util.Collection;
import javax.mail.FetchProfile;
import javax.mail.Message;

public class AttachmentTerm
extends SearchTerm<String> {
    private static final long serialVersionUID = 2515235086017062070L;
    private String pattern;

    public AttachmentTerm(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.ATTACHMENT_NAME);
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        return false;
    }

    @Override
    public boolean matches(MailMessage mailMessage) throws OXException {
        return false;
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        return new AttachmentSearchTerm(this.pattern);
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return null;
    }

    @Override
    public void contributeTo(FetchProfile fetchProfile) {
    }

    public class AttachmentSearchTerm
    extends javax.mail.search.SearchTerm {
        private static final long serialVersionUID = 686347717555105068L;
        private String pattern;

        public AttachmentSearchTerm(String pattern) {
            this.pattern = pattern;
        }

        public boolean match(Message msg) {
            return false;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

