/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose.share;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.upload.impl.UploadUtility;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.json.compose.AbstractQuotaAwareComposeContext;
import com.openexchange.mail.json.compose.ComposeRequest;

public class ShareTransportComposeContext
extends AbstractQuotaAwareComposeContext {
    public ShareTransportComposeContext(ComposeRequest request) throws OXException {
        super(request);
    }

    @Override
    protected void onFileUploadQuotaExceeded(long uploadQuotaPerFile, long size, MailPart part) throws OXException {
        String fileName = part.getFileName();
        throw MailExceptionCode.UPLOAD_QUOTA_EXCEEDED_FOR_FILE.create(UploadUtility.getSize(uploadQuotaPerFile), null == fileName ? "" : fileName, UploadUtility.getSize(size));
    }

    @Override
    protected void onTotalUploadQuotaExceeded(long uploadQuota, long consumed) throws OXException {
        throw MailExceptionCode.UPLOAD_QUOTA_EXCEEDED.create(UploadUtility.getSize(uploadQuota));
    }
}

