/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose.share;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.i18n.Translator;
import com.openexchange.i18n.TranslatorFactory;
import com.openexchange.java.Strings;
import com.openexchange.java.UnsynchronizedStringWriter;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.json.compose.ComposeRequest;
import com.openexchange.mail.json.compose.Utilities;
import com.openexchange.mail.json.compose.share.Item;
import com.openexchange.mail.json.compose.share.MessageGenerators;
import com.openexchange.mail.json.compose.share.Recipient;
import com.openexchange.mail.json.compose.share.ShareComposeLink;
import com.openexchange.mail.json.compose.share.ShareComposeMessageInfo;
import com.openexchange.mail.json.compose.share.ShareReference;
import com.openexchange.mail.json.compose.share.ShareTransportComposeContext;
import com.openexchange.mail.json.compose.share.spi.MessageGenerator;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.session.Session;
import com.openexchange.templating.OXTemplate;
import com.openexchange.templating.TemplateService;
import com.openexchange.tools.session.ServerSession;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class DefaultMessageGenerator
implements MessageGenerator {
    private static final DefaultMessageGenerator INSTANCE = new DefaultMessageGenerator();
    protected static final String VARIABLE_LINK = "link";
    protected static final String VARIABLE_PASSWORD = "password";
    protected static final String VARIABLE_EXPIRATION = "expiration";
    protected static final String VARIABLE_FILES = "files";
    protected static final String VARIABLE_FILE_NAMES = "filenames";

    public static DefaultMessageGenerator getInstance() {
        return INSTANCE;
    }

    protected DefaultMessageGenerator() {
    }

    protected Context getContext(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getContext();
        }
        return ContextStorage.getStorageContext(session.getContextId());
    }

    protected User getSessionUser(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser();
        }
        return UserStorage.getInstance().getUser(session.getUserId(), this.getContext(session));
    }

    protected Locale getSessionUserLocale(Session session) throws OXException {
        return this.getSessionUser(session).getLocale();
    }

    protected Locale determineLocaleForExternalRecipients(ShareTransportComposeContext composeContext) throws OXException {
        Locale locale;
        ServerSession session = composeContext.getSession();
        String sLocale = Utilities.getValueFromProperty("com.openexchange.mail.compose.share.externalRecipientsLocale", "user-defined", session);
        if (Strings.isEmpty((String)sLocale) || "user-defined".equalsIgnoreCase(sLocale)) {
            locale = session.getUser().getLocale();
        } else {
            locale = LocaleTools.getLocale((String)sLocale);
            if (null == locale) {
                locale = session.getUser().getLocale();
            }
        }
        return locale;
    }

    protected boolean equalMessagesByLocale() {
        return true;
    }

    protected boolean loadPrefixFromTemplate() {
        return true;
    }

    protected String getTemplateName() {
        return "notify.share.compose.prefix.html.tmpl";
    }

    @Override
    public boolean applicableFor(ComposeRequest composeRequest) throws OXException {
        return true;
    }

    @Override
    public List<ComposedMailMessage> generateTransportMessagesFor(ShareComposeMessageInfo info, ShareReference shareReference) throws OXException {
        ShareComposeLink shareLink = info.getShareLink();
        Map<String, String> headers = DefaultMessageGenerator.mapFor("X-Open-Xchange-Share-Type", shareLink.getType(), "X-Open-Xchange-Share-URL", shareLink.getLink());
        return this.equalMessagesByLocale() ? this.generateEqualMessagesByLocale(info, shareLink, shareReference, headers) : this.generateIndividualMessages(info, shareLink, shareReference, headers);
    }

    protected List<ComposedMailMessage> generateEqualMessagesByLocale(ShareComposeMessageInfo info, ShareComposeLink shareLink, ShareReference shareReference, Map<String, String> headers) throws OXException {
        String password = info.getPassword();
        Date expirationDate = info.getExpirationDate();
        List<Recipient> recipients = info.getRecipients();
        LinkedHashMap<Locale, ComposedMailMessage> internalMessages = new LinkedHashMap<Locale, ComposedMailMessage>(recipients.size());
        LinkedHashMap<Locale, ComposedMailMessage> externalMessages = new LinkedHashMap<Locale, ComposedMailMessage>(recipients.size());
        Locale localeForExternalRecipients = null;
        for (Recipient recipient : recipients) {
            ComposedMailMessage composedMessage;
            if (recipient.isUser()) {
                Locale locale = recipient.getUser().getLocale();
                ComposedMailMessage composedMessage2 = (ComposedMailMessage)internalMessages.get(locale);
                if (null == composedMessage2) {
                    composedMessage2 = this.generateInternalVersion(recipient, info.getComposeContext(), shareLink, password, expirationDate, shareReference, headers);
                    internalMessages.put(locale, composedMessage2);
                    continue;
                }
                composedMessage2.addRecipient(this.addressFor(recipient));
                continue;
            }
            if (null == localeForExternalRecipients) {
                localeForExternalRecipients = this.determineLocaleForExternalRecipients(info.getComposeContext());
            }
            if (null == (composedMessage = (ComposedMailMessage)externalMessages.get(localeForExternalRecipients))) {
                composedMessage = this.generateExternalVersion(localeForExternalRecipients, recipient, info.getComposeContext(), shareLink, password, expirationDate, shareReference, headers);
                externalMessages.put(localeForExternalRecipients, composedMessage);
                continue;
            }
            composedMessage.addRecipient(this.addressFor(recipient));
        }
        ArrayList<ComposedMailMessage> messages = new ArrayList<ComposedMailMessage>(internalMessages.size() + externalMessages.size());
        messages.addAll(internalMessages.values());
        messages.addAll(externalMessages.values());
        return messages;
    }

    protected List<ComposedMailMessage> generateIndividualMessages(ShareComposeMessageInfo info, ShareComposeLink shareLink, ShareReference shareReference, Map<String, String> headers) throws OXException {
        String password = info.getPassword();
        Date expirationDate = info.getExpirationDate();
        List<Recipient> recipients = info.getRecipients();
        ArrayList<ComposedMailMessage> messages = new ArrayList<ComposedMailMessage>(recipients.size());
        Locale localeForExternalRecipients = null;
        for (Recipient recipient : recipients) {
            if (recipient.isUser()) {
                messages.add(this.generateInternalVersion(recipient, info.getComposeContext(), shareLink, password, expirationDate, shareReference, headers));
                continue;
            }
            if (null == localeForExternalRecipients) {
                localeForExternalRecipients = this.determineLocaleForExternalRecipients(info.getComposeContext());
            }
            messages.add(this.generateExternalVersion(localeForExternalRecipients, recipient, info.getComposeContext(), shareLink, password, expirationDate, shareReference, headers));
        }
        return messages;
    }

    @Override
    public ComposedMailMessage generateSentMessageFor(ShareComposeMessageInfo info, ShareReference shareReference) throws OXException {
        Map<String, String> headers = DefaultMessageGenerator.mapFor("X-Open-Xchange-Share-Reference", ShareReference.generateStringForMime(shareReference));
        ComposedMailMessage sentMessage = this.generateInternalVersion(info.getRecipients().get(0), info.getComposeContext(), info.getShareLink(), info.getPassword(), info.getExpirationDate(), shareReference, headers);
        sentMessage.addUserFlag("$ShareReference");
        return sentMessage;
    }

    protected ComposedMailMessage generateInternalVersion(Recipient recipient, ShareTransportComposeContext composeContext, ShareComposeLink link, String password, Date elapsedDate, ShareReference shareReference, Map<String, String> shareHeaders) throws OXException {
        Locale locale = recipient.getUser().getLocale();
        return this.generateLocaleSpecificVersion(locale, recipient, composeContext, link, password, elapsedDate, shareReference, shareHeaders);
    }

    protected ComposedMailMessage generateExternalVersion(Locale localeForExternalRecipients, Recipient recipient, ShareTransportComposeContext composeContext, ShareComposeLink link, String password, Date elapsedDate, ShareReference shareReference, Map<String, String> shareHeaders) throws OXException {
        return this.generateLocaleSpecificVersion(localeForExternalRecipients, recipient, composeContext, link, password, elapsedDate, shareReference, shareHeaders);
    }

    protected ComposedMailMessage generateLocaleSpecificVersion(Locale locale, Recipient recipient, ShareTransportComposeContext composeContext, ShareComposeLink link, String password, Date elapsedDate, ShareReference shareReference, Map<String, String> shareHeaders) throws OXException {
        ComposedMailMessage composedMessage = Utilities.copyOfSourceMessage(composeContext);
        TextBodyMailPart textPart = composeContext.getTextPart().copy();
        textPart.setPlainText(null);
        String text = (String)textPart.getContent();
        StringBuilder textBuilder = new StringBuilder(text.length() + 512);
        textBuilder.append(this.generatePrefix(locale, link, password, elapsedDate, shareReference, this.loadPrefixFromTemplate()));
        textBuilder.append(text);
        textPart.setText(textBuilder.toString());
        composedMessage.setBodyPart(textPart);
        composedMessage.addRecipient(this.addressFor(recipient));
        if (null != shareHeaders) {
            for (Map.Entry<String, String> header : shareHeaders.entrySet()) {
                composedMessage.setHeader(header.getKey(), header.getValue());
            }
        }
        return composedMessage;
    }

    private InternetAddress addressFor(Recipient recipient) throws OXException {
        try {
            String personal = recipient.getPersonal();
            return new QuotedInternetAddress(recipient.getAddress(), personal, "UTF-8");
        }
        catch (AddressException e) {
            throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
    }

    protected String generatePrefix(Locale locale, ShareComposeLink link, String password, Date elapsedDate, ShareReference shareReference, boolean fromTemplate) throws OXException {
        return fromTemplate ? this.loadPrefixFromTemplate(locale, link, password, elapsedDate, shareReference) : this.generatePrefixPlain(locale, link, password, elapsedDate, shareReference);
    }

    protected String generatePrefixPlain(Locale locale, ShareComposeLink link, String password, Date elapsedDate, ShareReference shareReference) throws OXException {
        TranslatorFactory translatorFactory = MessageGenerators.getTranslatorFactory();
        if (null == translatorFactory) {
            throw ServiceExceptionCode.absentService(TranslatorFactory.class);
        }
        Translator translator = translatorFactory.translatorFor(locale);
        StringBuilder textBuilder = new StringBuilder(512);
        String translated = translator.translate("The available attachments for this E-Mail can be accessed via the link %1$s");
        translated = String.format(translated, this.buildLink(link));
        textBuilder.append(HtmlProcessing.htmlFormat(translated)).append("<br>");
        if (password != null) {
            translated = translator.translate("Please use the following password to access the attachments %1$s");
            translated = String.format(translated, password);
            textBuilder.append(HtmlProcessing.htmlFormat(translated)).append("<br>");
        }
        if (elapsedDate != null) {
            translated = translator.translate("The link will expire on %1$s");
            translated = String.format(translated, DateFormat.getDateInstance(1, locale).format(elapsedDate));
            textBuilder.append(HtmlProcessing.htmlFormat(translated)).append("<br>");
        }
        textBuilder.append("<br>");
        return textBuilder.toString();
    }

    protected String loadPrefixFromTemplate(Locale locale, ShareComposeLink link, String password, Date elapsedDate, ShareReference shareReference) throws OXException {
        TemplateService templateService = MessageGenerators.getTemplateService();
        if (null == templateService) {
            throw ServiceExceptionCode.absentService(TemplateService.class);
        }
        TranslatorFactory translatorFactory = MessageGenerators.getTranslatorFactory();
        if (null == translatorFactory) {
            throw ServiceExceptionCode.absentService(TranslatorFactory.class);
        }
        Translator translator = translatorFactory.translatorFor(locale);
        HashMap<String, Object> vars = new HashMap<String, Object>(4);
        String translated = translator.translate("The available attachments for this E-Mail can be accessed via the link %1$s");
        translated = String.format(translated, this.buildLink(link));
        vars.put(VARIABLE_LINK, translated);
        if (null != password) {
            translated = translator.translate("Please use the following password to access the attachments %1$s");
            translated = String.format(translated, password);
            vars.put(VARIABLE_PASSWORD, translated);
        }
        if (null != elapsedDate) {
            translated = translator.translate("The link will expire on %1$s");
            translated = String.format(translated, DateFormat.getDateInstance(1, locale).format(elapsedDate));
            vars.put(VARIABLE_EXPIRATION, translated);
        }
        translated = translator.translate("The following attachments are accessible:");
        vars.put(VARIABLE_FILES, translated);
        List<Item> items = shareReference.getItems();
        ArrayList<String> fileNames = new ArrayList<String>(items.size());
        for (Item item : items) {
            String fileName = item.getName();
            fileNames.add(Strings.isEmpty((String)fileName) ? translator.translate("Unnamed") : fileName);
        }
        vars.put(VARIABLE_FILE_NAMES, fileNames);
        return this.compileTemplate(this.getTemplateName(), vars, templateService);
    }

    protected String compileTemplate(String templateFile, Map<String, Object> vars, TemplateService templateService) throws OXException {
        OXTemplate template = templateService.loadTemplate(templateFile);
        UnsynchronizedStringWriter writer = new UnsynchronizedStringWriter(2048);
        template.process(vars, (Writer)writer);
        return writer.toString();
    }

    protected String buildLink(ShareComposeLink composeLink) {
        String link = composeLink.getLink();
        char quot = link.indexOf(34) < 0 ? (char)'\"' : '\'';
        StringBuilder linkBuilder = new StringBuilder(128);
        linkBuilder.append("<a href=").append(quot).append(link).append(quot).append('>');
        String name = composeLink.getName();
        linkBuilder.append(null != name && name.length() > 0 ? name : link);
        linkBuilder.append("</a>");
        return linkBuilder.toString();
    }

    protected static Map<String, String> mapFor(String ... args) {
        if (null == args) {
            return null;
        }
        int length = args.length;
        if (0 == length || length % 2 != 0) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(length >> 1);
        for (int i = 0; i < length; i += 2) {
            map.put(args[i], args[i + 1]);
        }
        return map;
    }
}

