/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose.share;

import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFileStorageFolder;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Streams;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.json.compose.share.DefaultAttachmentStorage;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAttachmentStoragePeriodicCleaner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAttachmentStoragePeriodicCleaner.class);
    private final String id;
    private final AtomicBoolean active;

    public DefaultAttachmentStoragePeriodicCleaner(String id) {
        this.id = id;
        this.active = new AtomicBoolean(true);
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        try {
            DatabaseService databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
            if (null == databaseService) {
                throw ServiceExceptionCode.absentService(DatabaseService.class);
            }
            LinkedList<Integer> contextsIdInDifferentSchemas = new LinkedList<Integer>();
            List<Integer> contextIds = ContextStorage.getInstance().getAllContextIds();
            int size = contextIds.size();
            HashSet<Integer> processed = new HashSet<Integer>(size, 0.9f);
            Iterator<Integer> iter = contextIds.iterator();
            int k = size;
            while (k-- > 0) {
                Integer contextId = iter.next();
                if (!processed.add(contextId)) continue;
                contextsIdInDifferentSchemas.add(contextId);
                for (int contextInSameSchema : databaseService.getContextsInSameSchema(contextId.intValue())) {
                    processed.add(Autoboxing.I((int)contextInSameSchema));
                }
            }
            int size2 = contextsIdInDifferentSchemas.size();
            LOG.info("Periodic cleanup task for shared mail attachments starts. Going to check {} schemas...", (Object)Autoboxing.I((int)size2));
            long logTimeDistance = TimeUnit.SECONDS.toMillis(10L);
            long lastLogTime = start;
            Thread currentThread = Thread.currentThread();
            Iterator iter2 = contextsIdInDifferentSchemas.iterator();
            int i = 0;
            int k2 = size2;
            while (k2-- > 0) {
                int contextIdInSchema = (Integer)iter2.next();
                String schemaName = databaseService.getSchemaName(contextIdInSchema);
                int retry = 3;
                while (retry-- > 0) {
                    if (currentThread.isInterrupted() || !this.active.get()) {
                        LOG.info("Periodic cleanup task for shared mail attachments interrupted or stopped.");
                        return;
                    }
                    long now = System.currentTimeMillis();
                    if (now > lastLogTime + logTimeDistance) {
                        LOG.info("Periodic share cleanup task {}% finished ({}/{}).", new Object[]{Autoboxing.I((int)(i * 100 / size2)), Autoboxing.I((int)i), Autoboxing.I((int)size2)});
                        lastLogTime = now;
                    }
                    try {
                        this.cleanupSchema(contextIdInSchema, start, schemaName, databaseService);
                        retry = 0;
                    }
                    catch (OXException e) {
                        if (Category.CATEGORY_TRY_AGAIN.equals(e.getCategory()) && retry > 0) {
                            long delay = 10000 + retry * 20000;
                            LOG.debug("Error during periodic cleanup task for shared mail attachments for schema {}: {}; trying again in {}ms...", new Object[]{schemaName, e.getMessage(), Autoboxing.L((long)delay)});
                            Thread.sleep(delay);
                            continue;
                        }
                        LOG.error("Error during periodic cleanup task for shared mail attachments for schema {}", (Object)schemaName, (Object)e);
                        retry = 0;
                    }
                }
                ++i;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted during periodic cleanup task for shared mail attachments: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            LOG.error("Error during periodic cleanup task for shared mail attachments: {}", (Object)e.getMessage(), (Object)e);
        }
        LOG.info("Periodic cleanup task for shared mail attachments finished after {}ms.", (Object)Autoboxing.L((long)(System.currentTimeMillis() - start)));
    }

    public void stop() {
        this.active.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupSchema(int contextIdInSchema, long threshold, String schemaName, DatabaseService databaseService) throws OXException {
        Map<Integer, Map<Integer, List<ExpiredFolder>>> expiredFoldersInSchema;
        Connection con = databaseService.getReadOnly(contextIdInSchema);
        try {
            expiredFoldersInSchema = this.determineExpiredFoldersInSchema(threshold, schemaName, con);
        }
        finally {
            databaseService.backReadOnly(contextIdInSchema, con);
        }
        this.cleanupExpiredFolders(expiredFoldersInSchema, threshold);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Integer, Map<Integer, List<ExpiredFolder>>> determineExpiredFoldersInSchema(long threshold, String schemaName, Connection con) throws OXException {
        LinkedHashMap<Integer, Map<Integer, List<ExpiredFolder>>> linkedHashMap;
        ResultSet rs;
        PreparedStatement stmt;
        block10: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT cid, fuid, created_from, meta FROM oxfolder_tree WHERE meta LIKE '%\"expiration-date-%'");
            rs = stmt.executeQuery();
            if (rs.next()) break block10;
            Map<Integer, Map<Integer, List<ExpiredFolder>>> map = Collections.emptyMap();
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return map;
        }
        try {
            LinkedHashMap<Integer, Map<Integer, List<ExpiredFolder>>> expiredFoldersInSchema = new LinkedHashMap<Integer, Map<Integer, List<ExpiredFolder>>>();
            do {
                LinkedList<ExpiredFolder> folderIds;
                int contextId = rs.getInt(1);
                int fuid = rs.getInt(2);
                int owner = rs.getInt(3);
                Map<String, Object> meta = this.parseMeta(rs, fuid, contextId);
                Long millis = this.parseExpirationMillis(meta);
                if (null == millis || millis >= threshold) continue;
                LinkedHashMap<Integer, LinkedList<ExpiredFolder>> userExpiredFolders = (LinkedHashMap<Integer, LinkedList<ExpiredFolder>>)expiredFoldersInSchema.get(Autoboxing.I((int)contextId));
                if (null == userExpiredFolders) {
                    userExpiredFolders = new LinkedHashMap<Integer, LinkedList<ExpiredFolder>>();
                    expiredFoldersInSchema.put(Autoboxing.I((int)contextId), userExpiredFolders);
                }
                if (null == (folderIds = (LinkedList<ExpiredFolder>)userExpiredFolders.get(Autoboxing.I((int)owner)))) {
                    folderIds = new LinkedList<ExpiredFolder>();
                    userExpiredFolders.put(Autoboxing.I((int)owner), folderIds);
                }
                folderIds.add(new ExpiredFolder(fuid, meta));
            } while (rs.next() && this.active.get());
            linkedHashMap = expiredFoldersInSchema;
        }
        catch (OXException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    throw MailExceptionCode.UNEXPECTED_ERROR.create(e2, "Unexpected error during cleanup of shared mail attachments in schema \"" + schemaName + "\"");
                }
                catch (RuntimeException e3) {
                    throw MailExceptionCode.UNEXPECTED_ERROR.create(e3, "Unexpected error during cleanup of shared mail attachments in schema \"" + schemaName + "\"");
                }
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return linkedHashMap;
    }

    private void cleanupExpiredFolders(Map<Integer, Map<Integer, List<ExpiredFolder>>> expiredFoldersInSchema, long threshold) throws OXException {
        Iterator<Map.Entry<Integer, Map<Integer, List<ExpiredFolder>>>> schemaEntryIter = expiredFoldersInSchema.entrySet().iterator();
        while (this.active.get() && schemaEntryIter.hasNext()) {
            Map.Entry<Integer, Map<Integer, List<ExpiredFolder>>> contextEntry = schemaEntryIter.next();
            int contextId = contextEntry.getKey();
            Iterator<Map.Entry<Integer, List<ExpiredFolder>>> ctxEntryIter = contextEntry.getValue().entrySet().iterator();
            while (this.active.get() && ctxEntryIter.hasNext()) {
                Map.Entry<Integer, List<ExpiredFolder>> userEntry = ctxEntryIter.next();
                int userId = userEntry.getKey();
                FakeSession session = new FakeSession(userId, contextId);
                DefaultAttachmentStorage.DefaultAttachmentStorageContext context = new DefaultAttachmentStorage.DefaultAttachmentStorageContext(this.getFileAccess(session), this.getFolderAccess(session), session);
                this.cleanupExpiredUserFolder(userEntry.getValue(), threshold, context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupExpiredUserFolder(List<ExpiredFolder> folders2, long threshold, DefaultAttachmentStorage.DefaultAttachmentStorageContext context) throws OXException {
        boolean rollback = false;
        try {
            context.startTransaction();
            rollback = true;
            Iterator<ExpiredFolder> it = folders2.iterator();
            while (this.active.get() && it.hasNext()) {
                LinkedHashMap<String, Object> meta;
                DefaultFileStorageFolder folder;
                ExpiredFolder expiredFolder = it.next();
                FolderID folderId = this.createFolderIDFor(expiredFolder.folderId);
                SearchIterator si = context.fileAccess.getDocuments(folderId.toUniqueID(), Arrays.asList(File.Field.ID, File.Field.META)).results();
                LinkedList<String> toDelete = new LinkedList<String>();
                boolean leftOver = false;
                boolean dropExpirationFromFolder = false;
                Long nextExpiration = null;
                try {
                    while (si.hasNext()) {
                        File file = (File)si.next();
                        Long fileMillis = this.parseExpirationMillis(file.getMeta());
                        if (null == fileMillis) {
                            leftOver = true;
                            dropExpirationFromFolder = true;
                            continue;
                        }
                        if (fileMillis < threshold) {
                            toDelete.add(file.getId());
                            continue;
                        }
                        leftOver = true;
                        if (dropExpirationFromFolder || nextExpiration != null && nextExpiration <= fileMillis) continue;
                        nextExpiration = fileMillis;
                    }
                }
                finally {
                    SearchIterators.close((SearchIterator)si);
                }
                if (!toDelete.isEmpty()) {
                    context.fileAccess.removeDocument(toDelete, Long.MAX_VALUE, true);
                }
                if (!leftOver) {
                    context.folderAccess.deleteFolder(folderId.toUniqueID(), true);
                    continue;
                }
                if (dropExpirationFromFolder) {
                    folder = new DefaultFileStorageFolder();
                    folder.setId(folderId.toUniqueID());
                    meta = new LinkedHashMap<String, Object>(expiredFolder.meta);
                    meta.remove("expiration-date-" + this.id);
                    folder.setMeta(meta);
                    context.folderAccess.updateFolder(folderId.toUniqueID(), (FileStorageFolder)folder);
                    continue;
                }
                if (null == nextExpiration) continue;
                folder = new DefaultFileStorageFolder();
                folder.setId(folderId.toUniqueID());
                meta = new LinkedHashMap<String, Object>(expiredFolder.meta);
                meta.put("expiration-date-" + this.id, nextExpiration);
                folder.setMeta(meta);
                context.folderAccess.updateFolder(folderId.toUniqueID(), (FileStorageFolder)folder);
            }
            context.commit();
            rollback = false;
        }
        finally {
            if (rollback) {
                context.rollback();
            }
            context.finish();
        }
    }

    private FolderID createFolderIDFor(int folderId) {
        return new FolderID("com.openexchange.infostore", "infostore", Integer.toString(folderId));
    }

    private IDBasedFileAccess getFileAccess(Session session) throws OXException {
        IDBasedFileAccessFactory factory = ServerServiceRegistry.getServize(IDBasedFileAccessFactory.class);
        if (null == factory) {
            throw ServiceExceptionCode.absentService(IDBasedFileAccessFactory.class);
        }
        return factory.createAccess(session);
    }

    private IDBasedFolderAccess getFolderAccess(Session session) throws OXException {
        IDBasedFolderAccessFactory factory = ServerServiceRegistry.getServize(IDBasedFolderAccessFactory.class);
        if (null == factory) {
            throw ServiceExceptionCode.absentService(IDBasedFolderAccessFactory.class);
        }
        return factory.createAccess(session);
    }

    private Map<String, Object> parseMeta(ResultSet rs, int fuid, int cid) throws SQLException, OXException {
        InputStream jsonBlobStream = rs.getBinaryStream(4);
        if (!rs.wasNull() && null != jsonBlobStream) {
            try {
                Map<String, Object> map = OXFolderUtility.deserializeMeta(jsonBlobStream);
                return map;
            }
            catch (JSONException e) {
                throw OXFolderExceptionCode.FOLDER_COULD_NOT_BE_LOADED.create(e, Integer.toString(fuid), Integer.toString(cid));
            }
            finally {
                Streams.close((Closeable)jsonBlobStream);
            }
        }
        return null;
    }

    private Long parseExpirationMillis(Map<String, Object> meta) {
        Object object = meta.get("expiration-date-" + this.id);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return null;
    }

    private static final class ExpiredFolder {
        final int folderId;
        final Map<String, Object> meta;

        ExpiredFolder(int folderId, Map<String, Object> meta) {
            this.folderId = folderId;
            this.meta = meta;
        }
    }

    private static final class FakeSession
    implements Session,
    Serializable {
        private static final long serialVersionUID = -7064871783038587316L;
        private final int userId;
        private final int contextId;
        private final ConcurrentMap<String, Object> parameters;

        FakeSession(int userId, int contextId) {
            this.userId = userId;
            this.contextId = contextId;
            this.parameters = new ConcurrentHashMap<String, Object>(8, 0.9f, 1);
        }

        public int getContextId() {
            return this.contextId;
        }

        public String getLocalIp() {
            return null;
        }

        public void setLocalIp(String ip) {
        }

        public String getLoginName() {
            return null;
        }

        public boolean containsParameter(String name) {
            return this.parameters.containsKey(name);
        }

        public Object getParameter(String name) {
            return this.parameters.get(name);
        }

        public String getPassword() {
            return null;
        }

        public String getRandomToken() {
            return null;
        }

        public String getSecret() {
            return null;
        }

        public String getSessionID() {
            return null;
        }

        public int getUserId() {
            return this.userId;
        }

        public String getUserlogin() {
            return null;
        }

        public String getLogin() {
            return null;
        }

        public void setParameter(String name, Object value) {
            if (null == value) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, value);
            }
        }

        public String getAuthId() {
            return null;
        }

        public String getHash() {
            return null;
        }

        public void setHash(String hash) {
        }

        public String getClient() {
            return null;
        }

        public void setClient(String client) {
        }

        public boolean isTransient() {
            return false;
        }

        public Set<String> getParameterNames() {
            return this.parameters.keySet();
        }
    }
}

