/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose;

import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.DelegatingComposedMailMessage;
import com.openexchange.mail.json.compose.ComposeTransportResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class DefaultComposeTransportResult
implements ComposeTransportResult {
    private final List<? extends ComposedMailMessage> transportMessages;
    private final ComposedMailMessage sentMessage;

    public DefaultComposeTransportResult(List<? extends ComposedMailMessage> transportMessages, ComposedMailMessage sentMessage) {
        this(transportMessages, sentMessage, true);
    }

    public DefaultComposeTransportResult(List<? extends ComposedMailMessage> transportMessages, ComposedMailMessage sentMessage, boolean sanitize) {
        Validate.notNull(transportMessages, (String)"Transport messages must not be null");
        Validate.notNull((Object)sentMessage, (String)"Sent message must not be null");
        if (sanitize) {
            ArrayList<? extends ComposedMailMessage> tmp = new ArrayList<ComposedMailMessage>(transportMessages.size());
            for (ComposedMailMessage composedMailMessage : transportMessages) {
                tmp.add(DefaultComposeTransportResult.sanitize(composedMailMessage, false));
            }
            this.transportMessages = tmp;
        } else {
            this.transportMessages = transportMessages;
        }
        this.sentMessage = sanitize ? DefaultComposeTransportResult.sanitize(sentMessage, true) : sentMessage;
    }

    @Override
    public List<? extends ComposedMailMessage> getTransportMessages() {
        return this.transportMessages;
    }

    @Override
    public ComposedMailMessage getSentMessage() {
        return this.sentMessage;
    }

    private static ComposedMailMessage sanitize(ComposedMailMessage toSanitize, boolean expect) {
        if (expect) {
            if (!toSanitize.isAppendToSentFolder()) {
                DelegatingComposedMailMessage wrappingMessage = new DelegatingComposedMailMessage(toSanitize);
                wrappingMessage.setAppendToSentFolder(true);
                return wrappingMessage;
            }
        } else if (toSanitize.isAppendToSentFolder()) {
            DelegatingComposedMailMessage wrappingMessage = new DelegatingComposedMailMessage(toSanitize);
            wrappingMessage.setAppendToSentFolder(false);
            return wrappingMessage;
        }
        return toSanitize;
    }
}

