/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose;

import com.openexchange.exception.OXException;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.ComposedMailPart;
import com.openexchange.mail.dataobjects.compose.DataMailPart;
import com.openexchange.mail.dataobjects.compose.InfostoreDocumentMailPart;
import com.openexchange.mail.dataobjects.compose.ReferencedMailPart;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.dataobjects.compose.UploadFileMailPart;
import com.openexchange.mail.json.compose.ComposeContext;
import com.openexchange.mail.json.compose.ComposeRequest;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.TransportProviderRegistry;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractComposeContext
implements ComposeContext {
    private final int accountId;
    private final ServerSession session;
    private final TransportProvider provider;
    private final TIntObjectMap<MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage>> mailAccesses;
    private ComposedMailMessage sourceMessage;
    private TextBodyMailPart textPart;
    private List<ReferencedMailPart> referencedParts;
    private List<DataMailPart> dataParts;
    private List<UploadFileMailPart> uploadedParts;
    private List<InfostoreDocumentMailPart> driveParts;

    protected AbstractComposeContext(ComposeRequest request) throws OXException {
        this(request.getAccountId(), request.getSession());
    }

    protected AbstractComposeContext(int accountId, ServerSession session) throws OXException {
        this.accountId = accountId;
        this.session = session;
        this.provider = TransportProviderRegistry.getTransportProviderBySession(session, accountId);
        this.mailAccesses = new TIntObjectHashMap(2);
    }

    protected abstract void onPartAdd(MailPart var1, ComposedMailPart var2) throws OXException;

    @Override
    public void setSourceMessage(ComposedMailMessage sourceMessage) {
        this.sourceMessage = sourceMessage;
    }

    @Override
    public ComposedMailMessage getSourceMessage() {
        return this.sourceMessage;
    }

    @Override
    public TransportProvider getProvider() {
        return this.provider;
    }

    @Override
    public int getAccountId() {
        return this.accountId;
    }

    @Override
    public ServerSession getSession() {
        return this.session;
    }

    @Override
    public TextBodyMailPart getTextPart() {
        return this.textPart;
    }

    @Override
    public void setTextPart(TextBodyMailPart textPart) {
        this.textPart = textPart;
    }

    @Override
    public List<MailPart> getAllParts() {
        LinkedList<MailPart> parts = new LinkedList<MailPart>();
        parts.addAll(this.getReferencedParts());
        parts.addAll(this.getDataParts());
        parts.addAll(this.getUploadParts());
        parts.addAll(this.getDriveParts());
        return parts;
    }

    @Override
    public boolean hasAnyPart() {
        if (!this.getReferencedParts().isEmpty()) {
            return true;
        }
        if (!this.getDataParts().isEmpty()) {
            return true;
        }
        if (!this.getUploadParts().isEmpty()) {
            return true;
        }
        return false == this.getDriveParts().isEmpty();
    }

    @Override
    public void addReferencedPart(ReferencedMailPart referencedPart) throws OXException {
        if (null != referencedPart) {
            List<ReferencedMailPart> referencedParts = this.referencedParts;
            if (null == referencedParts) {
                this.referencedParts = referencedParts = new ArrayList<ReferencedMailPart>(4);
            }
            this.onPartAdd(referencedPart, referencedPart);
            referencedParts.add(referencedPart);
        }
    }

    @Override
    public List<ReferencedMailPart> getReferencedParts() {
        return null == this.referencedParts ? Collections.emptyList() : this.referencedParts;
    }

    @Override
    public void addDataPart(DataMailPart dataPart) throws OXException {
        if (null != dataPart) {
            List<DataMailPart> dataParts = this.dataParts;
            if (null == dataParts) {
                this.dataParts = dataParts = new ArrayList<DataMailPart>(4);
            }
            this.onPartAdd(dataPart, dataPart);
            dataParts.add(dataPart);
        }
    }

    @Override
    public List<DataMailPart> getDataParts() {
        return null == this.dataParts ? Collections.emptyList() : this.dataParts;
    }

    @Override
    public void addUploadPart(UploadFileMailPart uploadPart) throws OXException {
        if (null != uploadPart) {
            List<UploadFileMailPart> uploadedParts = this.uploadedParts;
            if (null == uploadedParts) {
                this.uploadedParts = uploadedParts = new ArrayList<UploadFileMailPart>(4);
            }
            this.onPartAdd(uploadPart, uploadPart);
            uploadedParts.add(uploadPart);
        }
    }

    @Override
    public List<UploadFileMailPart> getUploadParts() {
        return null == this.uploadedParts ? Collections.emptyList() : this.uploadedParts;
    }

    @Override
    public void addDrivePart(InfostoreDocumentMailPart drivePart) throws OXException {
        if (null != drivePart) {
            List<InfostoreDocumentMailPart> driveParts = this.driveParts;
            if (null == driveParts) {
                this.driveParts = driveParts = new ArrayList<InfostoreDocumentMailPart>(4);
            }
            this.onPartAdd(drivePart, drivePart);
            driveParts.add(drivePart);
        }
    }

    @Override
    public List<InfostoreDocumentMailPart> getDriveParts() {
        return null == this.driveParts ? Collections.emptyList() : this.driveParts;
    }

    @Override
    public MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> getConnectedMailAccess(int accountId) throws OXException {
        return this.getMailAccess0(accountId, false);
    }

    @Override
    public MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> reconnectMailAccess(int accountId) throws OXException {
        return this.getMailAccess0(accountId, true);
    }

    private MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> getMailAccess0(int accountId, boolean reconnect) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = (MailAccess<IMailFolderStorage, IMailMessageStorage>)this.mailAccesses.get(accountId);
        if (null == mailAccess) {
            mailAccess = MailAccess.getInstance(this.session, accountId);
            this.mailAccesses.put(accountId, mailAccess);
            mailAccess.connect();
            return mailAccess;
        }
        if (reconnect) {
            mailAccess = MailAccess.reconnect((MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage>)mailAccess);
            this.mailAccesses.put(accountId, mailAccess);
        }
        return mailAccess;
    }

    @Override
    public void dispose() {
        TIntObjectIterator it = this.mailAccesses.iterator();
        int i = this.mailAccesses.size();
        while (i-- > 0) {
            it.advance();
            MailAccess mailAccess = (MailAccess)it.value();
            if (null == mailAccess) continue;
            mailAccess.close(true);
        }
    }
}

