/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions.helper;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.tools.session.ServerSession;
import com.sun.mail.util.FolderClosedIOException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public final class ReconnectingInputStreamClosure
implements IFileHolder.InputStreamClosure {
    private final ServerSession session;
    private final String id;
    private final String uid;
    private final MailPart mailPart;
    private final String folderPath;
    private final boolean image;
    private volatile ThresholdFileHolder tfh;

    public ReconnectingInputStreamClosure(MailPart mailPart, String folderPath, String uid, String id, boolean image, ServerSession session) {
        this.session = session;
        this.id = id;
        this.uid = uid;
        this.mailPart = mailPart;
        this.folderPath = folderPath;
        this.image = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream newStream() throws OXException, IOException {
        ThresholdFileHolder tfh = this.tfh;
        if (null != tfh) {
            return tfh.getStream();
        }
        InputStream partStream = null;
        boolean close = true;
        try {
            partStream = this.mailPart.getInputStream();
            PushbackInputStream in = new PushbackInputStream(partStream);
            int check = in.read();
            if (check < 0) {
                InputStream inputStream = Streams.EMPTY_INPUT_STREAM;
                return inputStream;
            }
            in.unread(check);
            close = false;
            PushbackInputStream pushbackInputStream = in;
            return pushbackInputStream;
        }
        catch (FolderClosedIOException e) {
            InputStream inputStream = this.reconnectAndGetStream();
            return inputStream;
        }
        finally {
            if (close) {
                Streams.close((Closeable)partStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream reconnectAndGetStream() throws OXException {
        FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(this.folderPath);
        MailAccess<IMailFolderStorage, IMailMessageStorage> ma = null;
        try {
            ma = MailAccess.getInstance(this.session, fa.getAccountId());
            ma.connect(false);
            ThresholdFileHolder newTfh = new ThresholdFileHolder();
            if (this.image) {
                newTfh.write(ma.getMessageStorage().getImageAttachment(fa.getFullName(), this.uid, this.id).getInputStream());
            } else {
                newTfh.write(ma.getMessageStorage().getAttachment(fa.getFullName(), this.uid, this.id).getInputStream());
            }
            this.tfh = newTfh;
            InputStream inputStream = newTfh.getStream();
            return inputStream;
        }
        finally {
            if (null != ma) {
                ma.close(true);
            }
        }
    }
}

