/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects.compose;

import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.attachment.storage.DefaultMailAttachmentStorageRegistry;
import com.openexchange.mail.attachment.storage.MailAttachmentInfo;
import com.openexchange.mail.attachment.storage.MailAttachmentStorage;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailPart;
import com.openexchange.session.Session;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataHandler;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InfostoreDocumentMailPart
extends MailPart
implements ComposedMailPart {
    private static final long serialVersionUID = -3158021272821196715L;
    private static final transient Logger LOG = LoggerFactory.getLogger(InfostoreDocumentMailPart.class);
    private final transient Session session;
    private final transient String documentId;
    private transient Object cachedContent;

    public InfostoreDocumentMailPart(String documentId, Session session) throws OXException {
        this.documentId = documentId;
        this.session = session;
        MailAttachmentStorage attachmentStorage = DefaultMailAttachmentStorageRegistry.getInstance().getMailAttachmentStorage();
        MailAttachmentInfo attachment = attachmentStorage.getAttachmentInfo(documentId, session);
        this.setSize(attachment.getSize());
        this.setContentType(attachment.getContentType());
        String fileName = attachment.getName();
        if (!Strings.isEmpty((String)fileName)) {
            try {
                this.setFileName(MimeUtility.encodeText((String)fileName, (String)MailProperties.getInstance().getDefaultMimeCharset(), (String)"Q"));
            }
            catch (UnsupportedEncodingException e) {
                this.setFileName(fileName);
            }
        }
    }

    @Override
    public Object getContent() throws OXException {
        Object content;
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        MailAttachmentStorage attachmentStorage = DefaultMailAttachmentStorageRegistry.getInstance().getMailAttachmentStorage();
        this.cachedContent = content = attachmentStorage.getAttachment(this.documentId, this.session).getContent();
        return content;
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        MailAttachmentStorage attachmentStorage = DefaultMailAttachmentStorageRegistry.getInstance().getMailAttachmentStorage();
        return attachmentStorage.getAttachment(this.documentId, this.session).getDataHandler();
    }

    @Override
    public int getEnclosedCount() throws OXException {
        return -1;
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws OXException {
        MailAttachmentStorage attachmentStorage = DefaultMailAttachmentStorageRegistry.getInstance().getMailAttachmentStorage();
        return attachmentStorage.getAttachment(this.documentId, this.session).getInputStream();
    }

    @Override
    public void prepareForCaching() {
    }

    @Override
    public void loadContent() {
    }

    @Override
    public ComposedMailPart.ComposedPartType getType() {
        return ComposedMailPart.ComposedPartType.DOCUMENT;
    }
}

