/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.categories.internal;

import com.openexchange.capabilities.CapabilityService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.IValueHandlerExtended;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.SettingExceptionCodes;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.categories.MailCategoriesConfigService;
import com.openexchange.mail.categories.MailCategoryConfig;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MailCategoriesPreferenceItem
implements PreferencesItemService {
    final ServiceLookup lookupService;
    private static final String MAIL_CATEGORIES_CAPABILTY = "mail_categories";
    private static final String FIELD_LIST = "list";
    private static final String FIELD_FEATURE_ENABLED = "enabled";
    private static final String FIELD_FEATURE_FORCED = "forced";
    private static final String FIELD_FEATURE_INITIALIZED = "initialized";
    private static final String FIELD_ID = "id";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_ACTIVE = "active";
    private static final String FIELD_PERMISSIONS = "permissions";
    private static final String PERMISSION_RENAME = "rename";
    private static final String PERMISSION_DISABLE = "disable";
    private static final String PERMISSION_TRAIN = "train";

    public MailCategoriesPreferenceItem(ServiceLookup lookupService) {
        this.lookupService = lookupService;
    }

    @Override
    public String[] getPath() {
        return new String[]{"modules", "mail", "categories"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new IValueHandlerExtended(){

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasWebMail() && userConfig.getExtendedPermissions().contains(MailCategoriesPreferenceItem.MAIL_CATEGORIES_CAPABILTY);
            }

            @Override
            public boolean isAvailable(Session session, UserConfiguration userConfig) throws OXException {
                if (!userConfig.hasWebMail()) {
                    return false;
                }
                CapabilityService service = ServerServiceRegistry.getInstance().getService(CapabilityService.class);
                return service.getCapabilities(session).contains(MailCategoriesPreferenceItem.MAIL_CATEGORIES_CAPABILTY);
            }

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                JSONObject item = new JSONObject(3);
                try {
                    MailCategoriesConfigService service = (MailCategoriesConfigService)MailCategoriesPreferenceItem.this.lookupService.getOptionalService(MailCategoriesConfigService.class);
                    if (service != null) {
                        boolean mailCategoriesEnabled = service.isEnabled(session);
                        boolean mailCategoriesForced = service.isForced(session);
                        if (mailCategoriesForced) {
                            mailCategoriesEnabled = true;
                        }
                        item.put(MailCategoriesPreferenceItem.FIELD_FEATURE_ENABLED, mailCategoriesEnabled);
                        item.put(MailCategoriesPreferenceItem.FIELD_FEATURE_FORCED, mailCategoriesForced);
                        item.put(MailCategoriesPreferenceItem.FIELD_FEATURE_INITIALIZED, (Object)service.getInitStatus(session));
                        List configs = service.getAllCategories(session, user.getLocale(), false, true);
                        JSONArray categories = new JSONArray();
                        for (MailCategoryConfig config : configs) {
                            JSONObject categoryJSON = new JSONObject(3);
                            categoryJSON.put(MailCategoriesPreferenceItem.FIELD_ID, (Object)config.getCategory());
                            categoryJSON.put(MailCategoriesPreferenceItem.FIELD_NAME, (Object)config.getName());
                            categoryJSON.put(MailCategoriesPreferenceItem.FIELD_DESCRIPTION, (Object)config.getDescription());
                            categoryJSON.put(MailCategoriesPreferenceItem.FIELD_ACTIVE, config.isActive());
                            ArrayList<String> mailCategoryPermissions = new ArrayList<String>();
                            if (!config.isForced()) {
                                mailCategoryPermissions.add(MailCategoriesPreferenceItem.PERMISSION_DISABLE);
                            }
                            if (!config.isSystemCategory()) {
                                mailCategoryPermissions.add(MailCategoriesPreferenceItem.PERMISSION_RENAME);
                            }
                            mailCategoryPermissions.add(MailCategoriesPreferenceItem.PERMISSION_TRAIN);
                            categoryJSON.put(MailCategoriesPreferenceItem.FIELD_PERMISSIONS, mailCategoryPermissions);
                            categories.put((Object)categoryJSON);
                        }
                        item.put(MailCategoriesPreferenceItem.FIELD_LIST, (Object)categories);
                    } else {
                        item.put(MailCategoriesPreferenceItem.FIELD_FEATURE_ENABLED, false);
                    }
                    setting.setSingleValue(item);
                }
                catch (JSONException e) {
                    throw OXJSONExceptionCodes.JSON_WRITE_ERROR.create();
                }
            }

            @Override
            public boolean isWritable() {
                return true;
            }

            @Override
            public void writeValue(Session session, Context ctx, User user, Setting setting) throws OXException {
                block9: {
                    CapabilityService capabilityService = (CapabilityService)MailCategoriesPreferenceItem.this.lookupService.getService(CapabilityService.class);
                    if (capabilityService == null || !capabilityService.getCapabilities(session).contains(MailCategoriesPreferenceItem.MAIL_CATEGORIES_CAPABILTY)) {
                        return;
                    }
                    JSONObject config = this.getType(setting.getSingleValue(), JSONObject.class, setting.getSingleValue(), setting.getName());
                    try {
                        MailCategoriesConfigService service = (MailCategoriesConfigService)MailCategoriesPreferenceItem.this.lookupService.getOptionalService(MailCategoriesConfigService.class);
                        if (service == null) {
                            return;
                        }
                        boolean featureEnabled = config.getBoolean(MailCategoriesPreferenceItem.FIELD_FEATURE_ENABLED);
                        if (!service.isForced(session)) {
                            service.enable(session, featureEnabled);
                        }
                        JSONArray mailCategories = this.getType(config.get(MailCategoriesPreferenceItem.FIELD_LIST), JSONArray.class, setting.getSingleValue(), setting.getName());
                        ArrayList<MailCategoryConfig> newConfigs = new ArrayList<MailCategoryConfig>();
                        for (Object o : mailCategories.asList()) {
                            Map newConfJSON = this.getType(o, Map.class, setting.getSingleValue(), setting.getName());
                            String catID = this.getType(newConfJSON.remove(MailCategoriesPreferenceItem.FIELD_ID), String.class, setting.getSingleValue(), setting.getName());
                            String name = this.getType(newConfJSON.remove(MailCategoriesPreferenceItem.FIELD_NAME), String.class, setting.getSingleValue(), setting.getName());
                            Boolean enable = this.getType(newConfJSON.remove(MailCategoriesPreferenceItem.FIELD_ACTIVE), Boolean.class, setting.getSingleValue(), setting.getName());
                            newConfJSON.remove(MailCategoriesPreferenceItem.FIELD_PERMISSIONS);
                            newConfJSON.remove(MailCategoriesPreferenceItem.FIELD_DESCRIPTION);
                            if (!newConfJSON.isEmpty()) {
                                throw SettingExceptionCodes.INVALID_VALUE.create(setting.getSingleValue(), setting.getName());
                            }
                            MailCategoryConfig.Builder builder = new MailCategoryConfig.Builder();
                            MailCategoryConfig mcc = builder.category(catID).enabled(enable.booleanValue()).name(name).build();
                            newConfigs.add(mcc);
                        }
                        if (newConfigs.isEmpty()) break block9;
                        try {
                            service.updateConfigurations(newConfigs, session, user.getLocale());
                        }
                        catch (OXException e) {
                            throw SettingExceptionCodes.NOT_ALLOWED.create();
                        }
                    }
                    catch (JSONException e) {
                        throw SettingExceptionCodes.INVALID_VALUE.create(setting.getSingleValue(), setting.getName());
                    }
                }
            }

            private <T> T getType(Object o, Class<T> clazz, Object exceptionObject, String name) throws OXException {
                if (!clazz.isInstance(o)) {
                    throw SettingExceptionCodes.INVALID_VALUE.create(exceptionObject, name);
                }
                return clazz.cast(o);
            }

            @Override
            public int getId() {
                return -1;
            }
        };
    }
}

