/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.api.permittance;

import com.openexchange.session.Session;

public final class PermitterKey {
    private final int contextId;
    private final int userId;
    private final int accountId;
    private final int hash;

    public static PermitterKey keyFor(int accountId, Session session) {
        return PermitterKey.keyFor(accountId, session.getUserId(), session.getContextId());
    }

    public static PermitterKey keyFor(int accountId, int userId, int contextId) {
        return new PermitterKey(accountId, userId, contextId);
    }

    private PermitterKey(int accountId, int userId, int contextId) {
        this.accountId = accountId;
        this.userId = userId;
        this.contextId = contextId;
        int prime = 31;
        int result = prime * 1 + contextId;
        result = prime * result + userId;
        this.hash = result = prime * result + accountId;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PermitterKey)) {
            return false;
        }
        PermitterKey pk = (PermitterKey)obj;
        if (this.contextId != pk.contextId) {
            return false;
        }
        if (this.userId != pk.userId) {
            return false;
        }
        return this.accountId == pk.accountId;
    }
}

