/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.login.internal.format;

import com.openexchange.java.Strings;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.format.DefaultLoginFormatter;
import com.openexchange.login.internal.format.LoginFormatter;
import com.openexchange.login.internal.format.StaticLoginFormatter;
import com.openexchange.login.internal.format.TokenFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeLoginFormatter
implements LoginFormatter {
    private final List<LoginFormatter> loginFormatters;
    private final List<LoginFormatter> logoutFormatters;

    public static void main(String[] args) {
        CompositeLoginFormatter cp = new CompositeLoginFormatter("$u $c $s $agent $client ende", null);
        System.out.println(cp.loginFormatters);
    }

    private static List<LoginFormatter> parseFormat(String format) {
        if (Strings.isEmpty((String)format)) {
            return null;
        }
        Logger logger = LoggerFactory.getLogger(CompositeLoginFormatter.class);
        try {
            String ws;
            String frm = format.trim();
            Pattern pattern = Pattern.compile("\\$[a-zA-Z]+");
            Matcher m = pattern.matcher(frm);
            LinkedList<LoginFormatter> formatters = new LinkedList<LoginFormatter>();
            int off = 0;
            while (m.find()) {
                String id = m.group().substring(1);
                TokenFormatter tokenFormatter = TokenFormatter.tokenFormatterFor(id);
                if (null == tokenFormatter) {
                    logger.warn("Invalid login format: \"{}\". Using default format.", (Object)format);
                    return null;
                }
                String ws2 = frm.substring(off, m.start());
                if (ws2.length() > 0) {
                    formatters.add(new StaticLoginFormatter(ws2));
                }
                formatters.add(tokenFormatter);
                off = m.end();
            }
            if (off < frm.length() && (ws = frm.substring(off)).length() > 0) {
                formatters.add(new StaticLoginFormatter(ws));
            }
            return formatters;
        }
        catch (Exception e) {
            logger.warn("Parsing format string failed. Using default format.", (Throwable)e);
            return null;
        }
    }

    public CompositeLoginFormatter(String loginFormat, String logoutFormat) {
        this(CompositeLoginFormatter.parseFormat(loginFormat), CompositeLoginFormatter.parseFormat(logoutFormat));
    }

    public CompositeLoginFormatter(List<LoginFormatter> loginFormatters, List<LoginFormatter> logoutFormatters) {
        this.loginFormatters = null == loginFormatters || loginFormatters.isEmpty() ? null : loginFormatters;
        this.logoutFormatters = null == logoutFormatters || logoutFormatters.isEmpty() ? null : logoutFormatters;
    }

    public List<LoginFormatter> getLoginFormatters() {
        return this.loginFormatters;
    }

    public List<LoginFormatter> getLogoutFormatters() {
        return this.logoutFormatters;
    }

    @Override
    public void formatLogin(LoginRequest request, LoginResult result, StringBuilder logBuilder) {
        List<LoginFormatter> loginFormatters = this.loginFormatters;
        if (null == loginFormatters) {
            DefaultLoginFormatter.getInstance().formatLogin(request, result, logBuilder);
        } else {
            for (LoginFormatter formatter : loginFormatters) {
                formatter.formatLogin(request, result, logBuilder);
            }
        }
    }

    @Override
    public void formatLogout(LoginResult result, StringBuilder logBuilder) {
        List<LoginFormatter> logoutFormatters = this.logoutFormatters;
        if (null == logoutFormatters) {
            DefaultLoginFormatter.getInstance().formatLogout(result, logBuilder);
        } else {
            for (LoginFormatter formatter : logoutFormatters) {
                formatter.formatLogout(result, logBuilder);
            }
        }
    }
}

