/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.server.services.ServerServiceRegistry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RemoveFacebookAccountsTask
implements UpdateTaskV2 {
    private static final String OAUTH_ID = "com.openexchange.oauth.facebook";
    private static final String MESSAGING_ID = "com.openexchange.messaging.facebook";

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        DatabaseService ds = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = ds.getForUpdateTask(contextId);
        boolean rb = false;
        try {
            con.setAutoCommit(false);
            rb = true;
            this.removeOAuthAccounts(con);
            this.removeMessagingAccounts(con);
            con.commit();
            rb = false;
        }
        catch (SQLException x) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(x, x.getMessage());
        }
        finally {
            if (rb) {
                Databases.rollback((Connection)con);
            }
            if (con != null) {
                Databases.autocommit((Connection)con);
                ds.backForUpdateTask(contextId, con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOAuthAccounts(Connection con) throws SQLException {
        if (!Databases.tablesExist((Connection)con, (String[])new String[]{"oauthAccounts"})) {
            return;
        }
        try (PreparedStatement stmt = con.prepareStatement("DELETE FROM oauthAccounts WHERE serviceId = ?");){
            stmt.setString(1, OAUTH_ID);
            stmt.executeUpdate();
        }
    }

    private void removeMessagingAccounts(Connection con) throws OXException, SQLException {
        if (!Databases.tablesExist((Connection)con, (String[])new String[]{"messagingAccount"})) {
            return;
        }
        List<int[]> dataList = this.listFacebookMessagingAccounts(con);
        for (int[] data : dataList) {
            this.dropAccountByData(data, con);
        }
    }

    private List<int[]> listFacebookMessagingAccounts(Connection con) throws OXException {
        ArrayList<int[]> arrayList;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT account, confId, user, cid FROM messagingAccount WHERE serviceId = ?");
            stmt.setString(1, MESSAGING_ID);
            rs = stmt.executeQuery();
            if (rs.next()) break block6;
            List<int[]> list = Collections.emptyList();
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return list;
        }
        try {
            ArrayList<int[]> dataList = new ArrayList<int[]>(64);
            do {
                int[] data = new int[]{rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getInt(4)};
                dataList.add(data);
            } while (rs.next());
            arrayList = dataList;
        }
        catch (SQLException e) {
            try {
                throw this.createSQLError(e);
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return arrayList;
    }

    private void dropAccountByData(int[] data, Connection writeCon) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement("DELETE FROM genconf_attributes_strings WHERE cid = ? AND id = ?");
            stmt.setInt(1, data[3]);
            stmt.setInt(2, data[1]);
            stmt.executeUpdate();
            stmt.close();
            stmt = writeCon.prepareStatement("DELETE FROM messagingAccount WHERE cid = ? AND user = ? AND serviceId = ? AND account = ?");
            stmt.setInt(1, data[3]);
            stmt.setInt(2, data[2]);
            stmt.setString(3, MESSAGING_ID);
            stmt.setInt(4, data[0]);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            throw this.createSQLError(e);
        }
        finally {
            Databases.closeSQLStuff((Statement)stmt);
        }
    }

    private OXException createSQLError(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND);
    }
}

