/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.MigrateAliasUpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class RemoveAliasInUserAttributesTable
extends UpdateTaskAdapter {
    private static final String DELETE_ALIAS_STMT = "DELETE FROM user_attribute WHERE name='alias'";

    @Override
    public void perform(PerformParameters params) throws OXException {
        int ctxId = params.getContextId();
        Connection conn = Database.getNoTimeout(ctxId, true);
        Statement stmt = null;
        boolean rollback = false;
        try {
            conn.setAutoCommit(false);
            rollback = true;
            stmt = conn.createStatement();
            stmt.execute(DELETE_ALIAS_STMT);
            conn.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(conn);
            }
            DBUtils.autocommit(conn);
            DBUtils.closeSQLStuff(stmt);
            Database.backNoTimeout(ctxId, true, conn);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{MigrateAliasUpdateTask.class.getName()};
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND);
    }
}

