/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppointmentClearDelTablesTasks
extends UpdateTaskAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(AppointmentClearDelTablesTasks.class);

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextID = params.getContextId();
        DatabaseService databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection connection = databaseService.getForUpdateTask(contextID);
        try {
            connection.setAutoCommit(false);
            LOG.info("Clearing obsolete fields in 'del_dates'...");
            int cleared = AppointmentClearDelTablesTasks.clearDeletedAppointments(connection);
            LOG.info("Cleared {} rows in 'del_dates'.", (Object)cleared);
            connection.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(connection);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(connection);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(connection);
            Database.backNoTimeout(contextID, true, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int clearDeletedAppointments(Connection connection) throws SQLException {
        int n;
        String[] columsToClear = new String[]{"timestampfield01", "timestampfield02", "timezone", "intfield03", "intfield04", "intfield05", "intfield06", "intfield07", "intfield08", "field01", "field02", "field04", "field06", "field07", "field08", "field09", "organizer", "sequence", "organizerId", "principal", "principalId"};
        StringBuilder StringBuilder2 = new StringBuilder("UPDATE del_dates SET ").append(columsToClear[0]).append("=NULL");
        for (int i = 1; i < columsToClear.length; ++i) {
            StringBuilder2.append(',').append(columsToClear[i]).append("=NULL");
        }
        StringBuilder2.append(';');
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(StringBuilder2.toString());
            n = statement.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(statement);
            throw throwable;
        }
        DBUtils.closeSQLStuff(statement);
        return n;
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND);
    }
}

