/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.UUID;

public class AddUUIDForDListTables
extends UpdateTaskAdapter {
    private static final String TABLE = "prg_dlist";
    private static final String DEL_TABLE = "del_dlist";
    private static final String NULL = " IS NULL ";
    private static final String EQUALS = " = ? ";

    @Override
    public void perform(PerformParameters params) throws OXException {
        int ctxId = params.getContextId();
        ProgressState progress = params.getProgressState();
        Connection con = Database.getNoTimeout(ctxId, true);
        try {
            DBUtils.startTransaction(con);
            progress.setTotal(this.getTotalRows(con));
            Tools.checkAndAddColumns(con, TABLE, new Column("uuid", "BINARY(16) DEFAULT NULL"));
            AddUUIDForDListTables.fillUUIDs(con, TABLE, progress);
            Tools.checkAndAddColumns(con, DEL_TABLE, new Column("uuid", "BINARY(16) DEFAULT NULL"));
            AddUUIDForDListTables.fillUUIDs(con, DEL_TABLE, progress);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(ctxId, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillUUIDs(Connection con, String table, ProgressState progress) throws SQLException {
        Statement select = null;
        ResultSet result = null;
        try {
            select = con.createStatement();
            result = select.executeQuery("SELECT intfield01, intfield02, intfield03, intfield04, field01, field02, field03, cid FROM " + table + " WHERE uuid IS NULL");
            while (result.next()) {
                String update = "UPDATE " + table + " SET uuid=? WHERE uuid IS NULL ";
                ArrayList<Object> values = new ArrayList<Object>();
                values.add(UUIDs.toByteArray((UUID)UUID.randomUUID()));
                update = update + "AND intfield01";
                int intfield01 = result.getInt("intfield01");
                if (result.wasNull()) {
                    update = update + NULL;
                } else {
                    update = update + EQUALS;
                    values.add(intfield01);
                }
                update = update + "AND intfield02";
                int intfield02 = result.getInt("intfield02");
                if (result.wasNull()) {
                    update = update + NULL;
                } else {
                    update = update + EQUALS;
                    values.add(intfield02);
                }
                update = update + "AND intfield03";
                int intfield03 = result.getInt("intfield03");
                if (result.wasNull()) {
                    update = update + NULL;
                } else {
                    update = update + EQUALS;
                    values.add(intfield03);
                }
                update = update + "AND intfield04";
                int intfield04 = result.getInt("intfield04");
                if (result.wasNull()) {
                    update = update + NULL;
                } else {
                    update = update + EQUALS;
                    values.add(intfield04);
                }
                update = update + "AND field01";
                String field01 = result.getString("field01");
                if (result.wasNull()) {
                    update = update + NULL;
                } else {
                    update = update + EQUALS;
                    values.add(field01);
                }
                update = update + "AND field02";
                String field02 = result.getString("field02");
                if (result.wasNull()) {
                    update = update + NULL;
                } else {
                    update = update + EQUALS;
                    values.add(field02);
                }
                update = update + "AND field03";
                String field03 = result.getString("field03");
                if (result.wasNull()) {
                    update = update + NULL;
                } else {
                    update = update + EQUALS;
                    values.add(field03);
                }
                update = update + "AND cid";
                int cid = result.getInt("cid");
                if (result.wasNull()) {
                    update = update + NULL;
                } else {
                    update = update + EQUALS;
                    values.add(cid);
                }
                update = update + " LIMIT 1";
                PreparedStatement upd = null;
                try {
                    int increment;
                    upd = con.prepareStatement(update);
                    for (int i = 0; i < values.size(); ++i) {
                        upd.setObject(i + 1, values.get(i));
                    }
                    int i = increment = upd.executeUpdate();
                    while (i-- > 0) {
                        progress.incrementState();
                    }
                }
                finally {
                    DBUtils.closeSQLStuff(upd);
                }
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result, select);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result, select);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTotalRows(Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        Statement stmt2 = null;
        ResultSet rs2 = null;
        int rows = 0;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM prg_dlist");
            while (rs.next()) {
                rows += rs.getInt(1);
            }
            stmt2 = con.createStatement();
            rs2 = stmt2.executeQuery("SELECT COUNT(*) FROM del_dlist");
            while (rs2.next()) {
                rows += rs2.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            DBUtils.closeSQLStuff(rs2, stmt2);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        DBUtils.closeSQLStuff(rs2, stmt2);
        return rows;
    }

    @Override
    public String[] getDependencies() {
        return new String[]{"com.openexchange.groupware.update.tasks.DListAddIndexForLookup"};
    }
}

