/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.api2.TasksSQLInterface;
import com.openexchange.contactcollector.ContactCollectorService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.groupware.tasks.ConfirmTask;
import com.openexchange.groupware.tasks.DeleteData;
import com.openexchange.groupware.tasks.ExternalParticipant;
import com.openexchange.groupware.tasks.FindTask;
import com.openexchange.groupware.tasks.GetTask;
import com.openexchange.groupware.tasks.InsertData;
import com.openexchange.groupware.tasks.Permission;
import com.openexchange.groupware.tasks.Search;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskParticipant;
import com.openexchange.groupware.tasks.TaskSearch;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.groupware.tasks.UpdateData;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.ArrayIterator;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TasksSQLImpl
implements TasksSQLInterface {
    private static final Logger LOG = LoggerFactory.getLogger(TasksSQLImpl.class);
    private final Session session;

    public TasksSQLImpl(Session session) {
        this.session = session;
    }

    @Override
    public SearchIterator<Task> getTaskList(int folderId, int from, int until, int orderBy, Order order, int[] columns) throws OXException {
        FolderObject folder;
        UserPermissionBits permissionBits;
        User user;
        Context ctx;
        int userId = this.session.getUserId();
        try {
            ctx = Tools.getContext(this.session.getContextId());
            user = Tools.getUser(ctx, userId);
            permissionBits = Tools.getUserPermissionBits(ctx, userId);
            folder = Tools.getFolder(ctx, folderId);
        }
        catch (OXException e) {
            if (OXFolderExceptionCode.NOT_EXISTS.equals(e)) {
                return SearchIteratorAdapter.emptyIterator();
            }
            throw e;
        }
        boolean onlyOwn = Permission.canReadInFolder(ctx, user, permissionBits, folder);
        boolean noPrivate = Tools.isFolderShared(folder, user);
        return TaskStorage.getInstance().list(ctx, folderId, from, until, orderBy, order, columns, onlyOwn, userId, noPrivate);
    }

    @Override
    public Task getTaskById(int taskId, int folderId) throws OXException {
        Context ctx = Tools.getContext(this.session.getContextId());
        int userId = this.session.getUserId();
        User user = Tools.getUser(ctx, userId);
        UserPermissionBits permissionBits = Tools.getUserPermissionBits(ctx, userId);
        try {
            GetTask get = new GetTask(ctx, user, permissionBits, folderId, taskId, StorageType.ACTIVE);
            return get.loadAndCheck();
        }
        catch (OXException e) {
            if (OXFolderExceptionCode.NOT_EXISTS.equals(e)) {
                try {
                    DeleteData deleteData = new DeleteData(ctx, user, permissionBits, null, taskId, null);
                    deleteData.doDeleteHard(this.session, folderId, StorageType.ACTIVE);
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private SearchIterator<Task> getModifiedTasksInFolder(int folderId, int[] columns, Date since, StorageType type) throws OXException {
        FolderObject folder;
        UserPermissionBits permissionBits;
        User user;
        Context ctx;
        int userId = this.session.getUserId();
        try {
            ctx = Tools.getContext(this.session.getContextId());
            user = Tools.getUser(ctx, userId);
            permissionBits = Tools.getUserPermissionBits(ctx, userId);
            folder = Tools.getFolder(ctx, folderId);
        }
        catch (OXException e) {
            if (OXFolderExceptionCode.NOT_EXISTS.equals(e)) {
                return SearchIteratorAdapter.emptyIterator();
            }
            throw e;
        }
        boolean onlyOwn = Permission.canReadInFolder(ctx, user, permissionBits, folder);
        boolean noPrivate = Tools.isFolderShared(folder, user);
        return TaskSearch.getInstance().listModifiedTasks(ctx, folderId, type, columns, since, onlyOwn, userId, noPrivate);
    }

    @Override
    public SearchIterator<Task> getModifiedTasksInFolder(int folderId, int[] columns, Date since) throws OXException {
        return this.getModifiedTasksInFolder(folderId, columns, since, StorageType.ACTIVE);
    }

    @Override
    public SearchIterator<Task> getDeletedTasksInFolder(int folderId, int[] columns, Date since) throws OXException {
        return this.getModifiedTasksInFolder(folderId, columns, since, StorageType.DELETED);
    }

    @Override
    public void insertTaskObject(Task task) throws OXException {
        Context ctx = Tools.getContext(this.session.getContextId());
        int userId = this.session.getUserId();
        User user = Tools.getUser(ctx, userId);
        UserPermissionBits permissionBits = Tools.getUserPermissionBits(ctx, userId);
        int folderId = task.getParentFolderID();
        FolderObject folder = Tools.getFolder(ctx, folderId);
        InsertData insert = new InsertData(ctx, user, permissionBits, folder, task);
        insert.prepare(this.session);
        insert.doInsert();
        insert.createReminder();
        insert.sentEvent(this.session);
        this.collectAddresses(task, false);
    }

    private void collectAddresses(Task task, boolean incrementUseCount) {
        if (task == null || task.getParticipants() == null) {
            LOG.debug("Provided Task object or containing participants null. Nothing to collect for the ContactCollector!");
            return;
        }
        ContactCollectorService contactCollectorService = ServerServiceRegistry.getInstance().getService(ContactCollectorService.class);
        if (contactCollectorService != null) {
            Participant[] participants = task.getParticipants();
            ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>(participants.length);
            for (Participant participant : participants) {
                String emailAddress = participant.getEmailAddress();
                try {
                    if (emailAddress == null) continue;
                    addresses.add(new InternetAddress(emailAddress));
                }
                catch (AddressException addressException) {
                    LOG.warn("Unable to add address " + emailAddress + " to ContactCollector.", (Throwable)addressException);
                }
            }
            contactCollectorService.memorizeAddresses(addresses, incrementUseCount, this.session);
        }
    }

    @Override
    public void updateTaskObject(Task task, int folderId, Date lastRead) throws OXException {
        int userId = this.session.getUserId();
        Context ctx = Tools.getContext(this.session.getContextId());
        User user = Tools.getUser(ctx, userId);
        UserPermissionBits permissionBits = Tools.getUserPermissionBits(ctx, userId);
        FolderObject folder = Tools.getFolder(ctx, folderId);
        UpdateData update = new UpdateData(ctx, user, permissionBits, folder, task, lastRead);
        update.prepare();
        update.doUpdate();
        update.sentEvent(this.session);
        update.updateReminder();
        update.makeNextRecurrence(this.session);
        this.collectAddresses(update, false);
    }

    private void collectAddresses(UpdateData update, boolean incrementUseCount) throws OXException {
        if (update == null) {
            LOG.info("Provided UpdateData object is null. Nothing to collect for the ContactCollector!");
            return;
        }
        ContactCollectorService contactCollectorService = ServerServiceRegistry.getInstance().getService(ContactCollectorService.class);
        Set<TaskParticipant> updatedParticipants = update.getUpdatedParticipants();
        if (contactCollectorService != null && !updatedParticipants.isEmpty()) {
            ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>(updatedParticipants.size());
            for (TaskParticipant participant : updatedParticipants) {
                if (participant.getType() != TaskParticipant.Type.EXTERNAL) continue;
                ExternalParticipant external = (ExternalParticipant)participant;
                String mail = external.getMail();
                try {
                    if (mail == null) continue;
                    addresses.add(new InternetAddress(mail));
                }
                catch (AddressException addressException) {
                    LOG.warn("Unable to add address " + mail + " to ContactCollector.", (Throwable)addressException);
                }
            }
            contactCollectorService.memorizeAddresses(addresses, incrementUseCount, this.session);
        }
    }

    @Override
    public void deleteTaskObject(int taskId, int folderId, Date lastModified) throws OXException {
        int userId = this.session.getUserId();
        Context ctx = Tools.getContext(this.session.getContextId());
        User user = Tools.getUser(ctx, userId);
        UserPermissionBits permissionBits = Tools.getUserPermissionBits(ctx, userId);
        FolderObject folder = Tools.getFolder(ctx, folderId);
        DeleteData delete = new DeleteData(ctx, user, permissionBits, folder, taskId, lastModified);
        delete.prepare();
        delete.doDelete();
        delete.sentEvent(this.session);
    }

    @Override
    public Date setUserConfirmation(int taskId, int userId, int confirm, String message) throws OXException {
        Context ctx = Tools.getContext(this.session.getContextId());
        ConfirmTask confirmT = new ConfirmTask(ctx, taskId, userId, confirm, message);
        confirmT.prepare();
        confirmT.doConfirmation();
        Date lastModified = confirmT.getLastModified();
        confirmT.sentEvent(this.session);
        return lastModified;
    }

    @Override
    public SearchIterator<Task> getObjectsById(int[][] ids, int[] columns) throws OXException {
        int userId = this.session.getUserId();
        Context ctx = Tools.getContext(this.session.getContextId());
        User user = Tools.getUser(ctx, userId);
        UserPermissionBits permissionBits = Tools.getUserPermissionBits(ctx, userId);
        ArrayList<Task> tasks2 = new ArrayList<Task>();
        for (int[] objectAndFolderId : ids) {
            GetTask get = new GetTask(ctx, user, permissionBits, objectAndFolderId[1], objectAndFolderId[0], StorageType.ACTIVE);
            try {
                tasks2.add(get.loadAndCheck());
            }
            catch (OXException e) {
                LOG.debug("", (Throwable)e);
            }
        }
        return new ArrayIterator((Object[])tasks2.toArray(new Task[tasks2.size()]));
    }

    @Override
    public SearchIterator<Task> getTasksByExtendedSearch(TaskSearchObject searchData, int orderBy, Order order, int[] columns) throws OXException {
        int userId = this.session.getUserId();
        Context ctx = Tools.getContext(this.session.getContextId());
        User user = Tools.getUser(ctx, userId);
        UserPermissionBits permissionBits = Tools.getUserPermissionBits(ctx, userId);
        Search search = new Search(ctx, user, permissionBits, searchData, orderBy, order, columns);
        return search.perform();
    }

    @Override
    public int countTasks(FolderObject folder) throws OXException {
        Context ctx = Tools.getContext(this.session.getContextId());
        int userId = this.session.getUserId();
        User user = Tools.getUser(ctx, userId);
        UserPermissionBits permissionBits = Tools.getUserPermissionBits(ctx, userId);
        boolean onlyOwn = Permission.canReadInFolder(ctx, user, permissionBits, folder);
        boolean isShared = 3 == folder.getType(userId);
        return TaskStorage.getInstance().countTasks(ctx, userId, folder.getObjectID(), onlyOwn, isShared);
    }

    @Override
    public SearchIterator<Task> findTask(TaskSearchObject searchObj, int orderBy, Order order, int[] cols) throws OXException {
        Context ctx = Tools.getContext(this.session.getContextId());
        int userID = this.session.getUserId();
        User user = Tools.getUser(ctx, userID);
        UserPermissionBits upb = Tools.getUserPermissionBits(ctx, userID);
        return new FindTask(ctx, user, upb, searchObj, orderBy, order, cols).perform();
    }
}

