/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.infostore.folder;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageAccountManager;
import com.openexchange.file.storage.FileStorageAccountManagerLookupService;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageFolderAccess;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.MediaFolderAwareFolderAccess;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.InfostoreFacades;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.ReadOnlyValue;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Videos
implements PreferencesItemService {
    private static final Logger LOG = LoggerFactory.getLogger(Videos.class);
    private static final String DEFAULT_ID = "0";

    @Override
    public String[] getPath() {
        return new String[]{"modules", "infostore", "folder", "videos"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new ReadOnlyValue(){

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasInfostore();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                if (user.isGuest()) {
                    return;
                }
                long start = System.currentTimeMillis();
                if (InfostoreFacades.isInfoStoreAvailable()) {
                    LOG.debug("After InfostoreFacades.isInfoStoreAvailable(): {}ms", (Object)(System.currentTimeMillis() - start));
                    int folderID = new OXFolderAccess(ctx).getDefaultFolderID(user.getId(), 8, 23);
                    LOG.debug("After OXFolderAccess(ctx).getDefaultFolder(): {}ms", (Object)(System.currentTimeMillis() - start));
                    if (-1 != folderID) {
                        setting.setSingleValue(folderID);
                    }
                    return;
                }
                FileStorageAccountManagerLookupService accountLookupService = ServerServiceRegistry.getServize(FileStorageAccountManagerLookupService.class);
                if (null == accountLookupService) {
                    throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{FileStorageAccountManagerLookupService.class.getName()});
                }
                try {
                    FileStorageAccountManager defaultAccountManager = accountLookupService.getAccountManager(Videos.DEFAULT_ID, session);
                    if (null != defaultAccountManager) {
                        FileStorageAccount defaultAccount = defaultAccountManager.getAccount(Videos.DEFAULT_ID, session);
                        FileStorageService fileStorageService = defaultAccount.getFileStorageService();
                        accountAccess.connect();
                        try (FileStorageAccountAccess accountAccess = fileStorageService.getAccountAccess(Videos.DEFAULT_ID, session);){
                            FileStorageFolderAccess fa = accountAccess.getFolderAccess();
                            if (fa instanceof MediaFolderAwareFolderAccess) {
                                FileStorageFolder videosFolder = ((MediaFolderAwareFolderAccess)fa).getVideosFolder();
                                setting.setSingleValue(new FolderID(fileStorageService.getId(), defaultAccount.getId(), videosFolder.getId()).toUniqueID());
                            }
                            return;
                        }
                    }
                }
                catch (OXException e) {
                    LOG.error("Infostore videos folder could not be applied to user configuration.", (Throwable)e);
                }
            }
        };
    }
}

