/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.SettingExceptionCodes;
import com.openexchange.groupware.settings.impl.AbstractUserFuncs;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.util.Set;

public final class BetaFeatures
implements PreferencesItemService {
    private static final String NAME = "beta";
    private static final String PROP_BETA = "com.openexchange.user.beta";

    @Override
    public String[] getPath() {
        return new String[]{NAME};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new AbstractUserFuncs(){

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                Set<String> set = user.getAttributes().get(BetaFeatures.NAME);
                if (null == set || set.isEmpty()) {
                    setting.setSingleValue(Autoboxing.B((boolean)BetaFeatures.getBooleanProperty(BetaFeatures.PROP_BETA, true)));
                } else {
                    setting.setSingleValue(Boolean.valueOf(set.iterator().next()));
                }
            }

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return true;
            }

            @Override
            public boolean isWritable() {
                return true;
            }

            @Override
            public void writeValue(Session session, Context ctx, User user, Setting setting) throws OXException {
                String value = setting.getSingleValue().toString();
                if (!"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
                    throw SettingExceptionCodes.INVALID_VALUE.create(value, BetaFeatures.NAME);
                }
                Set<String> set = user.getAttributes().get(BetaFeatures.NAME);
                if (null == set || set.isEmpty()) {
                    UserStorage.getInstance().setAttribute(BetaFeatures.NAME, value, user.getId(), ctx);
                } else if (Boolean.parseBoolean(set.iterator().next()) != Boolean.parseBoolean(value)) {
                    UserStorage.getInstance().setAttribute(BetaFeatures.NAME, value, user.getId(), ctx);
                }
            }
        };
    }

    static boolean getBooleanProperty(String name, boolean defaultValue) {
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (null == service) {
            return defaultValue;
        }
        return service.getBoolProperty(name, defaultValue);
    }
}

