/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.impl;

import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.Ranked;
import com.openexchange.groupware.settings.Setting;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;

public abstract class AbstractSetting<T extends AbstractSetting<? extends T>>
implements Setting {
    public static final char SEPARATOR = '/';
    private final int id;
    private T parent;
    private final IValueHandler shared;
    private final String name;
    private Map<String, PriorityQueue<T>> elements;
    private final int ranking;

    protected AbstractSetting(String name, int id, IValueHandler shared) {
        this.name = name;
        this.shared = shared;
        this.id = id;
        this.ranking = shared instanceof Ranked ? ((Ranked)((Object)shared)).getRanking() : 0;
    }

    @Override
    public int getRanking() {
        return this.ranking;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public T getElement(String subName) {
        AbstractSetting element = null;
        PriorityQueue<T> queue = this.optQueue(subName);
        if (null != queue) {
            element = (AbstractSetting)queue.peek();
        }
        return (T)element;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean isLeaf() {
        return null == this.elements || 0 == this.elements.size();
    }

    PriorityQueue<T> getQueue(String name) {
        if (null == this.elements) {
            this.elements = new HashMap<String, PriorityQueue<T>>();
            PriorityQueue newQueue = new PriorityQueue(4, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    int r2;
                    int r1 = ((AbstractSetting)o1).getRanking();
                    return r1 < (r2 = ((AbstractSetting)o2).getRanking()) ? 1 : (r1 == r2 ? 0 : -1);
                }
            });
            this.elements.put(name, newQueue);
            return newQueue;
        }
        PriorityQueue<Object> q = this.elements.get(name);
        if (null == q) {
            q = new PriorityQueue(4, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    int r2;
                    int r1 = ((AbstractSetting)o1).getRanking();
                    return r1 < (r2 = ((AbstractSetting)o2).getRanking()) ? 1 : (r1 == r2 ? 0 : -1);
                }
            });
            this.elements.put(name, q);
        }
        return q;
    }

    PriorityQueue<T> optQueue(String name) {
        if (null == this.elements) {
            return null;
        }
        return this.elements.get(name);
    }

    boolean checkElement(T child) {
        PriorityQueue<T> q = this.optQueue(((AbstractSetting)child).getName());
        if (null == q) {
            return true;
        }
        for (AbstractSetting t : q) {
            if (t.getRanking() != ((AbstractSetting)child).getRanking()) continue;
            return false;
        }
        return true;
    }

    void addElement(T child) {
        this.getQueue(((AbstractSetting)child).getName()).offer(child);
    }

    protected void removeElementInternal(T child) {
        PriorityQueue<T> q = this.optQueue(((AbstractSetting)child).getName());
        if (null != q) {
            q.remove(child);
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.name);
        if (null != this.elements) {
            out.append('(');
            for (PriorityQueue<T> q : this.elements.values()) {
                Iterator<T> iter = q.iterator();
                while (iter.hasNext()) {
                    out.append(String.valueOf(iter.next()));
                    if (!iter.hasNext()) continue;
                    out.append(',');
                }
            }
            out.append(')');
        }
        return out.toString();
    }

    public T[] getElements() {
        ArrayList<AbstractSetting> tmp = new ArrayList<AbstractSetting>();
        if (null != this.elements) {
            for (PriorityQueue<T> q : this.elements.values()) {
                AbstractSetting element = (AbstractSetting)q.peek();
                if (element == null) continue;
                tmp.add(element);
            }
        }
        AbstractSetting[] retval = (AbstractSetting[])Array.newInstance(this.getClass(), tmp.size());
        return tmp.toArray(retval);
    }

    @Override
    public boolean isShared() {
        return -1 == this.shared.getId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractSetting)) {
            return false;
        }
        AbstractSetting other = (AbstractSetting)obj;
        if (this.id != other.getId() || !this.name.equals(other.getName())) {
            return false;
        }
        return this.parent == null || ((AbstractSetting)this.parent).equals(other.getParent());
    }

    public int hashCode() {
        int retval = this.id ^ this.name.hashCode();
        if (this.isShared()) {
            retval ^= Boolean.TRUE.hashCode();
        }
        return retval;
    }

    public void setParent(T parent) {
        this.parent = parent;
    }

    @Override
    public String getPath() {
        return null == this.parent ? this.name : ((AbstractSetting)this.parent).getPath() + '/' + this.name;
    }

    public T getParent() {
        return this.parent;
    }

    @Override
    public IValueHandler getShared() {
        return this.shared;
    }
}

