/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder;

import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.reminder.ReminderExceptionCode;
import com.openexchange.groupware.reminder.ReminderHandler;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.iterator.SearchIterator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

class ReminderSearchIterator
implements SearchIterator<ReminderObject> {
    private ReminderObject next;
    private boolean closed = false;
    private final ResultSet rs;
    private final PreparedStatement preparedStatement;
    private final Connection readCon;
    private final List<OXException> warnings;
    private final Context ctx;

    ReminderSearchIterator(Context ctx, PreparedStatement preparedStatement, ResultSet rs, Connection readCon) throws OXException {
        this.ctx = ctx;
        this.warnings = new ArrayList<OXException>(2);
        this.rs = rs;
        this.readCon = readCon;
        this.preparedStatement = preparedStatement;
        try {
            this.next = ReminderHandler.result2Object(ctx, rs, preparedStatement, false);
        }
        catch (OXException exc) {
            this.next = null;
        }
        catch (SQLException exc) {
            throw ReminderExceptionCode.SQL_ERROR.create(exc, exc.getMessage());
        }
    }

    public boolean hasNext() throws OXException {
        return this.closed ? false : this.next != null;
    }

    public ReminderObject next() throws OXException {
        ReminderObject reminderObj = this.next;
        try {
            this.next = this.closed ? null : ReminderHandler.result2Object(this.ctx, this.rs, this.preparedStatement, false);
        }
        catch (OXException exc) {
            this.next = null;
        }
        catch (SQLException exc) {
            throw ReminderExceptionCode.SQL_ERROR.create(exc, exc.getMessage());
        }
        return reminderObj;
    }

    public void close() {
        Databases.closeSQLStuff((ResultSet)this.rs, (Statement)this.preparedStatement);
        DBPool.closeReaderSilent(this.ctx, this.readCon);
        this.closed = true;
    }

    public int size() {
        return -1;
    }

    public boolean hasSize() {
        return false;
    }

    public void addWarning(OXException warning) {
        this.warnings.add(warning);
    }

    public OXException[] getWarnings() {
        return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }
}

