/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.groupware.ldap.AttributeValue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class UserAttribute {
    private final String name;
    private final Set<AttributeValue> values;

    public UserAttribute(String name) {
        this.name = name;
        this.values = new HashSet<AttributeValue>();
    }

    public UserAttribute(String name, Set<String> values) {
        this(name);
        for (String value : values) {
            this.addValue(value);
        }
    }

    public String getName() {
        return this.name;
    }

    public Set<AttributeValue> getValues() {
        return this.values;
    }

    public Set<String> getStringValues() {
        HashSet<String> retval = new HashSet<String>();
        for (AttributeValue value : this.values) {
            retval.add(value.getValue());
        }
        return Collections.unmodifiableSet(retval);
    }

    AttributeValue getValue(String value) {
        for (AttributeValue tmp : this.values) {
            if (!tmp.getValue().equals(value)) continue;
            return tmp;
        }
        return null;
    }

    public boolean addValue(AttributeValue value) {
        return this.values.add(value);
    }

    void addValue(String value) {
        this.values.add(new AttributeValue(value));
    }

    public int size() {
        return this.values.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UserAttribute)) {
            return false;
        }
        UserAttribute other = (UserAttribute)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.values.equals(other.values);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append(this.name).append("=").append("[");
        for (AttributeValue value : this.values) {
            builder.append(value.toString()).append(',');
        }
        if (this.values.size() > 0) {
            builder.setCharAt(builder.length() - 1, ']');
        } else {
            builder.append("]");
        }
        return builder.toString();
    }
}

