/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.provider.DBProviderUser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.FolderLockManager;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.PathResolver;
import com.openexchange.groupware.infostore.Resolved;
import com.openexchange.groupware.infostore.WebdavFolderAliases;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurity;
import com.openexchange.groupware.infostore.webdav.DocumentMetadataResource;
import com.openexchange.groupware.infostore.webdav.EntityLockManager;
import com.openexchange.groupware.infostore.webdav.FolderCollection;
import com.openexchange.groupware.infostore.webdav.InfostoreLockNullResource;
import com.openexchange.groupware.infostore.webdav.OXWebdavResource;
import com.openexchange.groupware.infostore.webdav.PropertyStore;
import com.openexchange.groupware.infostore.webdav.URLCache;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.tx.TransactionAware;
import com.openexchange.webdav.loader.BulkLoader;
import com.openexchange.webdav.loader.LoadingHints;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.helpers.AbstractResource;
import com.openexchange.webdav.protocol.helpers.AbstractWebdavFactory;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfostoreWebdavFactory
extends AbstractWebdavFactory
implements BulkLoader {
    private static final Protocol PROTOCOL = new Protocol();
    private WebdavFolderAliases aliases;
    private final Set<TransactionAware> services = new HashSet<TransactionAware>();
    private final ThreadLocal<State> state = new ThreadLocal();
    private PathResolver resolver;
    private SessionHolder sessionHolder;
    private EntityLockManager lockNullLockManager;
    private EntityLockManager infoLockManager;
    private FolderLockManager folderLockManager;
    private PropertyStore infoProperties;
    private PropertyStore folderProperties;
    private InfostoreFacade database;
    private InfostoreSecurity security;
    private DBProvider provider;
    private final Logger LOG = LoggerFactory.getLogger(InfostoreWebdavFactory.class);

    @Override
    public Protocol getProtocol() {
        return PROTOCOL;
    }

    @Override
    public WebdavCollection resolveCollection(WebdavPath url) throws WebdavProtocolException {
        OXWebdavResource res;
        State s = this.state.get();
        if (s.folders.containsKey(url)) {
            return s.folders.get(url);
        }
        if (s.newFolders.containsKey(url)) {
            return s.newFolders.get(url);
        }
        if (s.lockNull.containsKey(url)) {
            InfostoreLockNullResource res2 = (InfostoreLockNullResource)s.lockNull.get(url);
            res2.setResource(new FolderCollection(url, this));
            return res2;
        }
        try {
            res = this.tryLoad(url, new FolderCollection(url, this));
            if (res.isLockNull()) {
                s.addLockNull(res);
            } else if (res.exists()) {
                s.addResource(res);
            } else {
                s.addNewResource(res);
            }
        }
        catch (OXException e) {
            throw WebdavProtocolException.generalError(e, url, 500);
        }
        if (!res.isCollection()) {
            throw WebdavProtocolException.generalError(url, 412);
        }
        return (WebdavCollection)((Object)res);
    }

    @Override
    public WebdavResource resolveResource(WebdavPath url) throws WebdavProtocolException {
        State s = this.state.get();
        if (s.resources.containsKey(url)) {
            return s.resources.get(url);
        }
        if (s.folders.containsKey(url)) {
            return s.folders.get(url);
        }
        if (s.newResources.containsKey(url)) {
            return s.newResources.get(url);
        }
        if (s.newFolders.containsKey(url)) {
            return s.newFolders.get(url);
        }
        if (s.lockNull.containsKey(url)) {
            InfostoreLockNullResource res = (InfostoreLockNullResource)s.lockNull.get(url);
            res.setResource(new DocumentMetadataResource(url, this));
            return res;
        }
        try {
            OXWebdavResource res = this.tryLoad(url, new DocumentMetadataResource(url, this));
            if (res.isLockNull()) {
                s.addLockNull(res);
            } else if (res.exists()) {
                s.addResource(res);
            } else {
                s.addNewResource(res);
            }
            return res;
        }
        catch (OXException e) {
            throw WebdavProtocolException.generalError(e, url, 500);
        }
    }

    private Set<TransactionAware> services() {
        return this.services;
    }

    private OXWebdavResource tryLoad(WebdavPath url, OXWebdavResource def) throws OXException {
        State s = this.state.get();
        ServerSession session = this.getSession();
        Context ctx = session.getContext();
        try {
            Resolved resolved = this.resolver.resolve(9, url, session);
            if (resolved.isFolder()) {
                return this.loadCollection(url, resolved.getId(), s);
            }
            DocumentMetadataResource resource = new DocumentMetadataResource(url, this);
            resource.setId(resolved.getId());
            resource.setExists(true);
            s.addResource(resource);
            return resource;
        }
        catch (OXException x) {
            if (x.isGeneric(OXException.Generic.NOT_FOUND)) {
                Connection readCon = null;
                try {
                    readCon = this.provider.getReadConnection(ctx);
                    int lockNullId = InfostoreLockNullResource.findInfostoreLockNullResource(url, readCon, ctx);
                    if (lockNullId > 0) {
                        InfostoreLockNullResource infostoreLockNullResource = new InfostoreLockNullResource((AbstractResource)((Object)def), this, lockNullId);
                        return infostoreLockNullResource;
                    }
                }
                catch (OXException e) {
                    throw e;
                }
                finally {
                    if (readCon != null) {
                        this.provider.releaseReadConnection(ctx, readCon);
                    }
                }
                return def;
            }
            throw x;
        }
    }

    private FolderCollection loadCollection(WebdavPath url, int id, State s) throws WebdavProtocolException {
        FolderCollection collection = new FolderCollection(url, this);
        collection.setId(id);
        collection.setExists(true);
        s.addCollection(collection);
        if (url == null) {
            collection.initUrl();
        }
        return collection;
    }

    @Override
    public void load(LoadingHints loading) {
        this.load(Arrays.asList(loading));
    }

    @Override
    public void load(List<LoadingHints> hints) {
    }

    public PathResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(PathResolver resolver) {
        this.removeService(this.resolver);
        this.resolver = resolver;
        this.addService(this.resolver);
    }

    public SessionHolder getSessionHolder() {
        return this.sessionHolder;
    }

    public void setSessionHolder(SessionHolder sessionHolder) {
        if (this.database != null) {
            this.database.setSessionHolder(sessionHolder);
        }
        this.sessionHolder = sessionHolder;
    }

    public FolderLockManager getFolderLockManager() {
        return this.folderLockManager;
    }

    public void setFolderLockManager(FolderLockManager folderLockManager) {
        this.removeService(this.folderLockManager);
        this.folderLockManager = folderLockManager;
        this.addService(this.folderLockManager);
    }

    public PropertyStore getFolderProperties() {
        return this.folderProperties;
    }

    public void setFolderProperties(PropertyStore folderProperties) {
        this.removeService(this.folderProperties);
        this.folderProperties = folderProperties;
        this.addService(this.folderProperties);
    }

    public EntityLockManager getInfoLockManager() {
        return this.infoLockManager;
    }

    public void setInfoLockManager(EntityLockManager infoLockManager) {
        this.removeService(this.infoLockManager);
        this.infoLockManager = infoLockManager;
        this.addService(this.infoLockManager);
    }

    public PropertyStore getInfoProperties() {
        return this.infoProperties;
    }

    public void setInfoProperties(PropertyStore infoProperties) {
        this.removeService(this.infoProperties);
        this.infoProperties = infoProperties;
        this.addService(this.infoProperties);
    }

    public EntityLockManager getLockNullLockManager() {
        return this.lockNullLockManager;
    }

    public void setLockNullLockManager(EntityLockManager infoLockManager) {
        this.removeService(this.lockNullLockManager);
        this.lockNullLockManager = infoLockManager;
        this.addService(this.lockNullLockManager);
    }

    public InfostoreFacade getDatabase() {
        return this.database;
    }

    public void setSecurity(InfostoreSecurity security) {
        if (this.security instanceof TransactionAware) {
            this.removeService((TransactionAware)this.security);
        }
        this.security = security;
        if (this.security instanceof TransactionAware) {
            this.addService((TransactionAware)this.security);
        }
    }

    public InfostoreSecurity getSecurity() {
        return this.security;
    }

    public void setDatabase(InfostoreFacade database) {
        if (this.sessionHolder != null) {
            database.setSessionHolder(this.sessionHolder);
        }
        this.removeService(this.database);
        this.database = database;
        this.addService(this.database);
    }

    public void setAliases(WebdavFolderAliases aliases) {
        this.aliases = aliases;
    }

    public WebdavFolderAliases getAliases() {
        return this.aliases;
    }

    public Collection<? extends OXWebdavResource> getCollections(List<Integer> subfolderIds) throws WebdavProtocolException {
        State s = this.state.get();
        HashSet<Integer> toLoad = new HashSet<Integer>(subfolderIds);
        ArrayList<Object> retVal = new ArrayList<Object>(subfolderIds.size());
        for (int id : subfolderIds) {
            if (!toLoad.contains(id) || !s.collectionsById.containsKey(id)) continue;
            retVal.add(s.collectionsById.get(id));
            toLoad.remove(id);
        }
        if (subfolderIds.isEmpty()) {
            return retVal;
        }
        for (int id : toLoad) {
            try {
                retVal.add(this.loadCollection(null, id, s));
            }
            catch (WebdavProtocolException x) {
                if (x.getStatus() == 403) continue;
                throw x;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends OXWebdavResource> getResourcesInFolder(FolderCollection collection, int folderId) throws OXException, IllegalAccessException, OXException {
        if (folderId == 9) {
            return new ArrayList();
        }
        State s = this.state.get();
        ServerSession session = this.getSession();
        EffectivePermission perm = collection.getEffectivePermission();
        if (!perm.canReadAllObjects() && !perm.canReadOwnObjects()) {
            return new ArrayList();
        }
        SearchIterator iter = this.database.getDocuments(folderId, session).results();
        try {
            ArrayList<DocumentMetadataResource> retVal = new ArrayList<DocumentMetadataResource>();
            while (iter.hasNext()) {
                DocumentMetadata docMeta = (DocumentMetadata)iter.next();
                if (null == docMeta.getFileName() || docMeta.getFileName().equals("")) continue;
                DocumentMetadataResource res = (DocumentMetadataResource)s.resourcesById.get(docMeta.getId());
                if (res == null) {
                    res = new DocumentMetadataResource(collection.getUrl().dup().append(docMeta.getFileName()), docMeta, this);
                    s.addResource(res);
                }
                retVal.add(res);
            }
            ArrayList<DocumentMetadataResource> arrayList = retVal;
            return arrayList;
        }
        finally {
            SearchIterators.close((SearchIterator)iter);
        }
    }

    private void addService(TransactionAware service) {
        this.services.add(service);
        if (service instanceof DBProviderUser) {
            DBProviderUser defService = (DBProviderUser)service;
            defService.setProvider(this.getProvider());
        }
    }

    private void removeService(TransactionAware service) {
        if (null == service) {
            return;
        }
        this.services.remove(service);
    }

    @Override
    public void beginRequest() {
        this.state.set(new State());
        for (TransactionAware service : this.services()) {
            try {
                service.startTransaction();
            }
            catch (OXException e) {
                this.LOG.error("", (Throwable)e);
            }
        }
    }

    @Override
    public void endRequest(int status) {
        this.state.set(null);
        for (TransactionAware service : this.services()) {
            try {
                service.finish();
            }
            catch (OXException e) {
                this.LOG.error("", (Throwable)e);
            }
        }
    }

    public DBProvider getProvider() {
        return this.provider;
    }

    public void setProvider(DBProvider provider) {
        this.provider = provider;
        for (TransactionAware service : this.services()) {
            if (!(service instanceof DBProviderUser)) continue;
            DBProviderUser defService = (DBProviderUser)service;
            defService.setProvider(this.getProvider());
        }
    }

    public void invalidate(WebdavPath url, int id, URLCache.Type type) {
        State s = this.state.get();
        s.invalidate(url, id, type);
        for (TransactionAware service : this.services) {
            if (!(service instanceof URLCache)) continue;
            URLCache urlCache = (URLCache)service;
            urlCache.invalidate(url, id, type);
        }
    }

    public void created(DocumentMetadataResource resource) throws WebdavProtocolException {
        State s = this.state.get();
        s.registerNew(resource);
    }

    public void created(FolderCollection collection) throws WebdavProtocolException {
        State s = this.state.get();
        s.registerNew(collection);
    }

    public void removed(OXWebdavResource resource) throws WebdavProtocolException {
        this.invalidate(resource.getUrl(), resource.getId(), resource.isCollection() ? URLCache.Type.COLLECTION : URLCache.Type.RESOURCE);
        State s = this.state.get();
        s.remove(resource);
    }

    public ServerSession getSession() throws OXException {
        return ServerSessionAdapter.valueOf(this.sessionHolder.getSessionObject());
    }

    private static final class State {
        public final Map<WebdavPath, DocumentMetadataResource> resources = new HashMap<WebdavPath, DocumentMetadataResource>();
        public final Map<WebdavPath, FolderCollection> folders = new HashMap<WebdavPath, FolderCollection>();
        public final Map<WebdavPath, DocumentMetadataResource> newResources = new HashMap<WebdavPath, DocumentMetadataResource>();
        public final Map<WebdavPath, FolderCollection> newFolders = new HashMap<WebdavPath, FolderCollection>();
        public final Map<WebdavPath, OXWebdavResource> lockNull = new HashMap<WebdavPath, OXWebdavResource>();
        public final TIntObjectMap<FolderCollection> collectionsById = new TIntObjectHashMap();
        public final TIntObjectMap<DocumentMetadataResource> resourcesById = new TIntObjectHashMap();

        private State() {
        }

        public void addResource(OXWebdavResource res) {
            if (res.isCollection()) {
                this.addCollection((FolderCollection)res);
            } else {
                this.addResource((DocumentMetadataResource)res);
            }
        }

        public void addResource(DocumentMetadataResource resource) {
            this.resources.put(resource.getUrl(), resource);
            this.resourcesById.put(resource.getId(), (Object)resource);
        }

        public void addCollection(FolderCollection collection) {
            this.folders.put(collection.getUrl(), collection);
            this.collectionsById.put(collection.getId(), (Object)collection);
        }

        public void invalidate(WebdavPath url, int id, URLCache.Type type) {
            this.lockNull.remove(url);
            switch (type) {
                case COLLECTION: {
                    this.folders.remove(url);
                    this.newFolders.remove(url);
                    this.collectionsById.remove(id);
                    return;
                }
                case RESOURCE: {
                    this.resources.remove(url);
                    this.newResources.remove(url);
                    this.resourcesById.remove(id);
                    return;
                }
            }
            throw new IllegalArgumentException("Unkown Type " + (Object)((Object)type));
        }

        public void remove(OXWebdavResource resource) throws WebdavProtocolException {
            int id = resource.getParentId();
            FolderCollection coll = this.getFolder(id);
            if (coll == null) {
                return;
            }
            coll.unregisterChild(resource);
        }

        public void registerNew(OXWebdavResource resource) throws WebdavProtocolException {
            if (resource.isCollection()) {
                this.collectionsById.put(resource.getId(), (Object)((FolderCollection)resource));
            } else {
                this.resourcesById.put(resource.getId(), (Object)((DocumentMetadataResource)resource));
            }
            int id = resource.getParentId();
            FolderCollection coll = this.getFolder(id);
            if (coll == null) {
                return;
            }
            coll.registerChild(resource);
        }

        private FolderCollection getFolder(int id) {
            return (FolderCollection)this.collectionsById.get(id);
        }

        public void addNewResource(OXWebdavResource res) {
            if (res.isCollection()) {
                this.newFolders.put(res.getUrl(), (FolderCollection)res);
            } else {
                this.newResources.put(res.getUrl(), (DocumentMetadataResource)res);
            }
        }

        public void addLockNull(OXWebdavResource res) {
            this.lockNull.put(res.getUrl(), res);
        }
    }
}

