/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.utils;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.utils.CombinedFilteringFileSearchIterator;
import com.openexchange.groupware.results.Delta;
import com.openexchange.tools.iterator.SearchIterator;

public class FileDelta
implements Delta<DocumentMetadata> {
    private final SearchIterator<DocumentMetadata> newOnes;
    private final SearchIterator<DocumentMetadata> modifiedOnes;
    private final SearchIterator<DocumentMetadata> deletedOnes;
    private final long sequenceNumber;

    public FileDelta(SearchIterator<DocumentMetadata> newOnes, SearchIterator<DocumentMetadata> modifiedOnes, SearchIterator<DocumentMetadata> deletedOnes, long sequenceNumber) {
        this.newOnes = newOnes;
        this.modifiedOnes = modifiedOnes;
        this.deletedOnes = deletedOnes;
        this.sequenceNumber = sequenceNumber;
    }

    public SearchIterator<DocumentMetadata> getNew() {
        return this.newOnes;
    }

    public SearchIterator<DocumentMetadata> getModified() {
        return this.modifiedOnes;
    }

    public SearchIterator<DocumentMetadata> getDeleted() {
        return this.deletedOnes;
    }

    public SearchIterator<DocumentMetadata> results() throws OXException {
        CombinedFilteringFileSearchIterator it = new CombinedFilteringFileSearchIterator(this.newOnes, this.modifiedOnes);
        return it;
    }

    public long sequenceNumber() throws OXException {
        return this.sequenceNumber;
    }

    public void close() throws OXException {
        this.newOnes.close();
        this.modifiedOnes.close();
        this.deletedOnes.close();
    }
}

