/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.search;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.search.ComparablePattern;
import com.openexchange.groupware.infostore.search.SearchTerm;
import java.util.Date;

public abstract class AbstractDateSearchTerm
implements SearchTerm<ComparablePattern<Date>> {
    protected final ComparablePattern<Date> pattern;

    protected AbstractDateSearchTerm(ComparablePattern<Date> pattern) {
        this.pattern = pattern;
    }

    @Override
    public ComparablePattern<Date> getPattern() {
        return this.pattern;
    }

    @Override
    public boolean matches(DocumentMetadata file) throws OXException {
        Date date = this.getDate(file);
        if (null == date) {
            return false;
        }
        switch (this.pattern.getComparisonType()) {
            case EQUALS: {
                return date.getTime() == this.pattern.getPattern().getTime();
            }
            case LESS_THAN: {
                return date.getTime() < this.pattern.getPattern().getTime();
            }
            case GREATER_THAN: {
                return date.getTime() > this.pattern.getPattern().getTime();
            }
        }
        return false;
    }

    protected abstract Date getDate(DocumentMetadata var1);
}

