/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.contact.ContactService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentAuthorization;
import com.openexchange.groupware.attach.AttachmentEvent;
import com.openexchange.groupware.attach.AttachmentListener;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;

public class ContactsAttachment
implements AttachmentListener,
AttachmentAuthorization {
    @Override
    public long attached(AttachmentEvent event) throws OXException {
        return ContactsAttachment.modifyAttachmentCount(event.getSession(), String.valueOf(event.getFolderId()), String.valueOf(event.getAttachedId()), 1);
    }

    @Override
    public long detached(AttachmentEvent event) throws OXException {
        return ContactsAttachment.modifyAttachmentCount(event.getSession(), String.valueOf(event.getFolderId()), String.valueOf(event.getAttachedId()), -1 * event.getDetached().length);
    }

    @Override
    public void checkMayAttach(ServerSession session, int folderId, int objectId) throws OXException {
        ContactsAttachment.checkPermissions(session, folderId, objectId, true, true);
    }

    @Override
    public void checkMayDetach(ServerSession session, int folderId, int objectId) throws OXException {
        this.checkMayAttach(session, folderId, objectId);
    }

    @Override
    public void checkMayReadAttachments(ServerSession session, int folderId, int objectId) throws OXException {
        ContactsAttachment.checkPermissions(session, folderId, objectId, true, false);
    }

    private static void checkPermissions(ServerSession session, int folderID, int objectID, boolean needsReadAccess, boolean needsWriteAccess) throws OXException {
        if (needsReadAccess || needsWriteAccess) {
            OXFolderAccess folderAccess = new OXFolderAccess(session.getContext());
            EffectivePermission permission = folderAccess.getFolderPermission(folderID, session.getUserId(), session.getUserConfiguration());
            if (needsReadAccess && !permission.canReadOwnObjects()) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderID), Autoboxing.I((int)session.getContextId()), Autoboxing.I((int)session.getUserId()));
            }
            if (needsWriteAccess && !permission.canWriteOwnObjects()) {
                throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Autoboxing.I((int)objectID), Autoboxing.I((int)session.getContextId()));
            }
            ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
            Contact contact = contactService.getContact(session, Integer.toString(folderID), Integer.toString(objectID), new ContactField[]{ContactField.CREATED_BY, ContactField.PRIVATE_FLAG});
            if (contact.getCreatedBy() != session.getUserId()) {
                if (contact.getPrivateFlag() || needsReadAccess && !permission.canReadAllObjects()) {
                    throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderID), Autoboxing.I((int)session.getContextId()), Autoboxing.I((int)session.getUserId()));
                }
                if (needsWriteAccess && !permission.canWriteAllObjects()) {
                    throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Autoboxing.I((int)objectID), Autoboxing.I((int)session.getContextId()));
                }
            }
        }
    }

    private static long modifyAttachmentCount(Session session, String folderID, String objectID, int delta) throws OXException {
        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
        Contact contact = contactService.getContact(session, folderID, objectID, new ContactField[]{ContactField.NUMBER_OF_ATTACHMENTS, ContactField.LAST_MODIFIED});
        if (0 > contact.getNumberOfAttachments() + delta) {
            throw ContactExceptionCodes.TOO_FEW_ATTACHMENTS.create();
        }
        if (0 != delta) {
            contact.setNumberOfAttachments(contact.getNumberOfAttachments() + delta);
            contactService.updateContact(session, folderID, objectID, contact, contact.getLastModified());
        }
        return contact.getLastModified().getTime();
    }
}

