/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.json;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.documentation.annotations.Module;
import com.openexchange.exception.OXException;
import com.openexchange.group.json.actions.AbstractGroupAction;
import com.openexchange.group.json.actions.AllAction;
import com.openexchange.group.json.actions.GetAction;
import com.openexchange.group.json.actions.ListAction;
import com.openexchange.group.json.actions.SearchAction;
import com.openexchange.group.json.actions.UpdatesAction;
import com.openexchange.server.ServiceLookup;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Module(name="group", description="The group module allows to query available groups. It is mainly used by the dialog for the selection of participants.")
@com.openexchange.ajax.requesthandler.Module(actions={"get", "all", "list", "search", "updates"})
public class GroupActionFactory
implements AJAXActionServiceFactory {
    private final Map<String, AbstractGroupAction> actions = new ConcurrentHashMap<String, AbstractGroupAction>(5, 0.9f, 1);

    public GroupActionFactory(ServiceLookup services) {
        this.actions.put("get", new GetAction(services));
        this.actions.put("all", new AllAction(services));
        this.actions.put("list", new ListAction(services));
        this.actions.put("search", new SearchAction(services));
        this.actions.put("updates", new UpdatesAction(services));
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }

    @Override
    public AJAXActionService createActionService(String action) throws OXException {
        return this.actions.get(action);
    }
}

